CREATE TABLE W83B12T00

(

  C_TRAM_012  NUMBER(4)                         NOT NULL,

  C_FASE_012  NUMBER(4)                         NOT NULL,

  DESC_012    VARCHAR2(250 BYTE),

  DESE_012    VARCHAR2(250 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B12T00 IS 'Tabla de Trmites';



COMMENT ON COLUMN W83B12T00.C_TRAM_012 IS 'Codigo de trmite';



COMMENT ON COLUMN W83B12T00.C_FASE_012 IS 'Codigo de fase';



COMMENT ON COLUMN W83B12T00.DESC_012 IS 'Descripcion de trmite en Castellano';



COMMENT ON COLUMN W83B12T00.DESE_012 IS 'Descripcion de trmite en Euskera';





CREATE OR REPLACE SYNONYM W83B12S00 FOR W83B12T00;





ALTER TABLE W83B12T00 ADD (

  CONSTRAINT PK_W83B12T00 PRIMARY KEY (C_TRAM_012, C_FASE_012)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B13T00

(

  C_CONV_013   NUMBER(4)                        NOT NULL,

  CEMPR_013    NUMBER(2),

  S_DIFE_013   VARCHAR2(1 BYTE)                 NOT NULL,

  S_ESP01_013  VARCHAR2(1 BYTE)                 NOT NULL,

  S_ESP20_013  VARCHAR2(1 BYTE)                 NOT NULL,

  S_ESP48_013  VARCHAR2(1 BYTE)                 NOT NULL,

  CMADRID_013  VARCHAR2(10 BYTE)                NOT NULL,

  DESC_013     VARCHAR2(250 BYTE),

  DESE_013     VARCHAR2(250 BYTE),

  F_BAJA_013   DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B13T00 IS 'Tabla de Convenios';



COMMENT ON COLUMN W83B13T00.C_CONV_013 IS 'Codigo de trmite';



COMMENT ON COLUMN W83B13T00.CEMPR_013 IS 'Tipo de empresa';



COMMENT ON COLUMN W83B13T00.S_DIFE_013 IS 'Indica si es un convenio por diferencias';



COMMENT ON COLUMN W83B13T00.S_ESP01_013 IS 'Especial Araba';



COMMENT ON COLUMN W83B13T00.S_ESP20_013 IS 'Especial Gipuzkoa';



COMMENT ON COLUMN W83B13T00.S_ESP48_013 IS 'Especial Bizkaia';



COMMENT ON COLUMN W83B13T00.CMADRID_013 IS 'Cdigo Madrid';



COMMENT ON COLUMN W83B13T00.DESC_013 IS 'Descripcion de trmite en Castellano';



COMMENT ON COLUMN W83B13T00.DESE_013 IS 'Descripcion de trmite en Euskera';



COMMENT ON COLUMN W83B13T00.F_BAJA_013 IS 'Fecha de baja';





CREATE OR REPLACE SYNONYM W83B13S00 FOR W83B13T00;





ALTER TABLE W83B13T00 ADD (

  CONSTRAINT PK_W83B13T00 PRIMARY KEY (C_CONV_013)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B14T00

(

  C_AGRU_014  NUMBER(4)                         NOT NULL,

  DESC_014    VARCHAR2(250 BYTE),

  DESE_014    VARCHAR2(250 BYTE),

  F_BAJA_014  DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B14T00 IS 'Tabla de Agrupaciones';



COMMENT ON COLUMN W83B14T00.C_AGRU_014 IS 'Codigo de agrupacin';



COMMENT ON COLUMN W83B14T00.DESC_014 IS 'Descripcion de agrupacin en Castellano';



COMMENT ON COLUMN W83B14T00.DESE_014 IS 'Descripcion de agrupacin en Euskera';



COMMENT ON COLUMN W83B14T00.F_BAJA_014 IS 'Fecha de baja';





CREATE OR REPLACE SYNONYM W83B14S00 FOR W83B14T00;





ALTER TABLE W83B14T00 ADD (

  CONSTRAINT PK_W83B14T00 PRIMARY KEY (C_AGRU_014)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B15T00

(

  C_CONV_015  NUMBER(4)                         NOT NULL,

  C_AGRU_015  NUMBER(4)                         NOT NULL

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B15T00 IS 'Tabla relacin de agrupaciones y convenios';



COMMENT ON COLUMN W83B15T00.C_CONV_015 IS 'Codigo de convenio';



COMMENT ON COLUMN W83B15T00.C_AGRU_015 IS 'Cdigo de agrupacin';





CREATE OR REPLACE SYNONYM W83B15S00 FOR W83B15T00;





ALTER TABLE W83B15T00 ADD (

  CONSTRAINT PK_W83B15T00 PRIMARY KEY (C_CONV_015, C_AGRU_015)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B16T00

(

  N_ACTA_016        NUMBER(6)                   NOT NULL,

  ANO_ACTA_016      NUMBER(4)                   NOT NULL,

  C_TERRIT_016      VARCHAR2(2 BYTE)            NOT NULL,

  VERSION_016       NUMBER(2)                   NOT NULL,

  N_PREAVISO_016    NUMBER(6),

  ANO_PREAVISO_016  NUMBER(4),

  C_CONV_016        NUMBER(4),

  ID_CENTRO_016     NUMBER(6)                   NOT NULL,

  CBAJA_016         VARCHAR2(2 BYTE),

  F_ENTRA_016       DATE                        NOT NULL,

  F_ELECC_016       DATE                        NOT NULL,

  TOTDEL_016        NUMBER(6),

  TOTELEC_016       NUMBER(6)                   NOT NULL,

  CANDH_016         NUMBER(6)                   NOT NULL,

  CANDM_016         NUMBER(6)                   NOT NULL,

  ANO_ACTTOT_016    NUMBER(4),

  N_ACTTOT_016      NUMBER(6),

  N_REG_016         VARCHAR2(15 BYTE),

  FREGLIB_016       DATE,

  ANO_REGDEF_016    NUMBER(4),

  N_REGDEF_016      NUMBER(5),

  FREGDEF_016       DATE,

  F_COMIS_016       DATE,

  F_REQUE_016       DATE,

  F_SUBREQ_016      DATE,

  F_RETCOM_016      DATE,

  F_PRRI_016        DATE,

  F_BAJA_016        DATE,

  DELH_016          NUMBER(6),

  DELM_016          NUMBER(6),

  ELECH_016         NUMBER(6),

  ELECM_016         NUMBER(6),

  S_COMI_016        VARCHAR2(1 BYTE),

  OBSERV_016        VARCHAR2(500 BYTE),

  USUA_016          VARCHAR2(10 BYTE),

  FACTU_016         DATE,

  INSPEC_016        NUMBER(1),

  F_CONSTCOM_016    DATE,

  VALIDADA_016      VARCHAR2(1 BYTE),

  MAXDEL_016        NUMBER(5),

  REMITE_016        VARCHAR2(150 BYTE),

  NUEVA_016 		NUMBER(1) DEFAULT 0

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B16T00 IS 'Tabla de actas';



COMMENT ON COLUMN W83B16T00.REMITE_016 IS 'Remitente';



COMMENT ON COLUMN W83B16T00.MAXDEL_016 IS 'Nmero mximo de delegados';



COMMENT ON COLUMN W83B16T00.N_ACTA_016 IS 'Nmero del acta';



COMMENT ON COLUMN W83B16T00.ANO_ACTA_016 IS 'Ao del acta';



COMMENT ON COLUMN W83B16T00.C_TERRIT_016 IS 'Territorio del acta';



COMMENT ON COLUMN W83B16T00.VERSION_016 IS 'Versin';



COMMENT ON COLUMN W83B16T00.N_PREAVISO_016 IS 'Nmero de preaviso';



COMMENT ON COLUMN W83B16T00.ANO_PREAVISO_016 IS 'Ao del preaviso';



COMMENT ON COLUMN W83B16T00.C_CONV_016 IS 'Cdigo convenio';



COMMENT ON COLUMN W83B16T00.ID_CENTRO_016 IS 'Id del centro de trabajo';



COMMENT ON COLUMN W83B16T00.CBAJA_016 IS 'Motivo de baja';



COMMENT ON COLUMN W83B16T00.F_ENTRA_016 IS 'FEcha de entrada';



COMMENT ON COLUMN W83B16T00.F_ELECC_016 IS 'Fecha de eleccin';



COMMENT ON COLUMN W83B16T00.TOTDEL_016 IS 'Nmero total de delegados';



COMMENT ON COLUMN W83B16T00.TOTELEC_016 IS 'Nmero total de electores';



COMMENT ON COLUMN W83B16T00.CANDH_016 IS 'Nmero de candidatos hombres';



COMMENT ON COLUMN W83B16T00.CANDM_016 IS 'Nmero de candidatos mujeres';



COMMENT ON COLUMN W83B16T00.ANO_ACTTOT_016 IS 'Ao del acta total';



COMMENT ON COLUMN W83B16T00.N_ACTTOT_016 IS 'Nmero del acta total';



COMMENT ON COLUMN W83B16T00.N_REG_016 IS 'Nmero del registo';



COMMENT ON COLUMN W83B16T00.FREGLIB_016 IS 'Fecha libro de registro';



COMMENT ON COLUMN W83B16T00.ANO_REGDEF_016 IS 'Ao registro definitivo';



COMMENT ON COLUMN W83B16T00.N_REGDEF_016 IS 'Nmero de registro definitivo';



COMMENT ON COLUMN W83B16T00.FREGDEF_016 IS 'Fecha de registro definitivo';



COMMENT ON COLUMN W83B16T00.F_COMIS_016 IS 'Fecha de comisin';



COMMENT ON COLUMN W83B16T00.F_REQUE_016 IS 'Fecha de requerimiento';



COMMENT ON COLUMN W83B16T00.F_SUBREQ_016 IS 'Fecha de requerimiento de subsanacin';



COMMENT ON COLUMN W83B16T00.F_RETCOM_016 IS 'Fecha de retirada de comunicacin';



COMMENT ON COLUMN W83B16T00.F_PRRI_016 IS 'Fecha PRRI';



COMMENT ON COLUMN W83B16T00.F_BAJA_016 IS 'Fecha de baja';



COMMENT ON COLUMN W83B16T00.DELH_016 IS 'Nmero de delegados hombres';



COMMENT ON COLUMN W83B16T00.DELM_016 IS 'Nmero de delegados mujeres';



COMMENT ON COLUMN W83B16T00.ELECH_016 IS 'Nmero de electores hombres';



COMMENT ON COLUMN W83B16T00.ELECM_016 IS 'Nmero de electores mujeres';



COMMENT ON COLUMN W83B16T00.S_COMI_016 IS 'Comsiin s/no';



COMMENT ON COLUMN W83B16T00.OBSERV_016 IS 'Observaciones';



COMMENT ON COLUMN W83B16T00.USUA_016 IS 'Usuario modificacin';



COMMENT ON COLUMN W83B16T00.FACTU_016 IS 'Fecha modificacin';



COMMENT ON COLUMN W83B16T00.INSPEC_016 IS 'Inspeccionada s/no';



COMMENT ON COLUMN W83B16T00.F_CONSTCOM_016 IS '.....??';



COMMENT ON COLUMN W83B16T00.VALIDADA_016 IS 'Validada, 0:No, 1:S';



COMMENT ON COLUMN W83B16T00.NUEVA_016 IS 'Indica si ha entrado en el cierre como nueva. 0=no, 1=si';





CREATE OR REPLACE SYNONYM W83B16S00 FOR W83B16T00;





ALTER TABLE W83B16T00 ADD (

  CONSTRAINT PK_W83B16T00 PRIMARY KEY (N_ACTA_016, ANO_ACTA_016, C_TERRIT_016, VERSION_016)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B17T00

(

  CBAJA_017   VARCHAR2(2 BYTE)                  NOT NULL,

  DESC_017    VARCHAR2(250 BYTE)                NOT NULL,

  DESE_017    VARCHAR2(250 BYTE),

  F_BAJA_017  DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B17T00 IS 'Tabla de Motivos de baja de actas';



COMMENT ON COLUMN W83B17T00.CBAJA_017 IS 'Cdigo de motivo';



COMMENT ON COLUMN W83B17T00.DESC_017 IS 'Descripcion de motivo de baja acta en Castellano';



COMMENT ON COLUMN W83B17T00.DESE_017 IS 'Descripcion de motivo de baja acta en Euskera';



COMMENT ON COLUMN W83B17T00.F_BAJA_017 IS 'Fecha de baja';





CREATE OR REPLACE SYNONYM W83B17S00 FOR W83B17T00;





ALTER TABLE W83B17T00 ADD (

  CONSTRAINT PK_W83B17T00 PRIMARY KEY (CBAJA_017)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B18T00

(

  N_ACTA_018    NUMBER(6)                       NOT NULL,

  ANO_ACTA_018  NUMBER(4)                       NOT NULL,

  C_TERRIT_018  VARCHAR2(2 BYTE)                NOT NULL,

  VERSION_018   NUMBER(2)                       NOT NULL,

  C_COLEG_018   NUMBER(3)                       NOT NULL,

  C_SINDI_018   NUMBER(3)                       NOT NULL,

  N_DELH_018    NUMBER(2)                       NOT NULL,

  N_DELM_018    NUMBER(2)                       NOT NULL,

  USUA_018      VARCHAR2(10 BYTE),

  FACTU_018     DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B18T00 IS 'Tabla de diferencias';



COMMENT ON COLUMN W83B18T00.N_ACTA_018 IS 'Nmero de acta';



COMMENT ON COLUMN W83B18T00.ANO_ACTA_018 IS 'Ao del acta';



COMMENT ON COLUMN W83B18T00.C_TERRIT_018 IS 'Territorio del acta';



COMMENT ON COLUMN W83B18T00.VERSION_018 IS 'Versin';



COMMENT ON COLUMN W83B18T00.C_COLEG_018 IS 'cdigo colegio';



COMMENT ON COLUMN W83B18T00.C_SINDI_018 IS 'Cdigo sindicato';



COMMENT ON COLUMN W83B18T00.N_DELH_018 IS 'Nmero de delegados hombres';



COMMENT ON COLUMN W83B18T00.N_DELM_018 IS 'Nmero de delegados mujeres';



COMMENT ON COLUMN W83B18T00.USUA_018 IS 'Usuario modificacin';



COMMENT ON COLUMN W83B18T00.FACTU_018 IS 'Fecha modificacin';





CREATE OR REPLACE SYNONYM W83B18S00 FOR W83B18T00;





ALTER TABLE W83B18T00 ADD (

  CONSTRAINT PK_W83B18T00 PRIMARY KEY (N_ACTA_018, ANO_ACTA_018, C_TERRIT_018, C_SINDI_018, C_COLEG_018, VERSION_018)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B19T00

(

  C_SINDI_019  NUMBER(3)                        NOT NULL,

  DESC_019     VARCHAR2(250 BYTE),

  SIGLAS_019   VARCHAR2(10 BYTE),

  CVERIF_019   NUMBER(2),

  CMADRID_019  VARCHAR2(6 BYTE),

  RELSTES_019  VARCHAR2(1 BYTE)                 DEFAULT 'N',

  DESE_019     VARCHAR2(250 BYTE),

  F_BAJA_019   DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B19T00 IS 'Tabla de sindicatos';



COMMENT ON COLUMN W83B19T00.C_SINDI_019 IS 'Cdigo de sindicato';



COMMENT ON COLUMN W83B19T00.DESC_019 IS 'Descripcion de sindicato en Castellano';



COMMENT ON COLUMN W83B19T00.SIGLAS_019 IS 'Siglas del sindicato';



COMMENT ON COLUMN W83B19T00.CVERIF_019 IS 'Cdigo de verificacin';



COMMENT ON COLUMN W83B19T00.CMADRID_019 IS 'Cdigo Madrid';



COMMENT ON COLUMN W83B19T00.RELSTES_019 IS 'Indica si est de alta en STES';



COMMENT ON COLUMN W83B19T00.DESE_019 IS 'Descripcion de sindicato en Euskera';



COMMENT ON COLUMN W83B19T00.F_BAJA_019 IS 'Fecha de baja';





CREATE OR REPLACE SYNONYM W83B19S00 FOR W83B19T00;





ALTER TABLE W83B19T00 ADD (

  CONSTRAINT PK_W83B19T00 PRIMARY KEY (C_SINDI_019)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B20T00

(

  ID_DOC_020     NUMBER(7)                      NOT NULL,

  N_ACTA_020     NUMBER(6)                      NOT NULL,

  ANO_ACTA_020   NUMBER(4)                      NOT NULL,

  C_TERRIT_020   VARCHAR2(2 BYTE)               NOT NULL,

  VERSION_020    NUMBER(2)                      NOT NULL,

  C_TRAM_020     NUMBER(4)                      NOT NULL,

  C_FASE_020     NUMBER(4)                      NOT NULL,

  NOMB_DOCU_020  VARCHAR2(100 BYTE),

  LONG_DOCU_020  NUMBER(10),

  DOCUMENTO_020  BLOB,

  TP_DOC_020     NUMBER(3),

  NUM_REG_020    VARCHAR2(15 BYTE),

  F_REG_020      DATE,

  USUARIO_020    VARCHAR2(100 BYTE),

  F_ACTU_020     DATE

)

TABLESPACE W8311E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

LOB (DOCUMENTO_020) STORE AS

      ( TABLESPACE  W8311E00 

        DISABLE     STORAGE IN ROW

        CHUNK       8192

        PCTVERSION  0

        NOCACHE

        STORAGE    (

                    INITIAL          128K

                    NEXT             128K

                    MINEXTENTS       1

                    MAXEXTENTS       2147483645

                    PCTINCREASE      0

                    BUFFER_POOL      DEFAULT

                   )

      )

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B20T00 IS 'Tabla de documentos adjuntos al acta';



COMMENT ON COLUMN W83B20T00.NOMB_DOCU_020 IS 'Nombre del documento';



COMMENT ON COLUMN W83B20T00.LONG_DOCU_020 IS 'Longitud del documento';



COMMENT ON COLUMN W83B20T00.DOCUMENTO_020 IS 'Documento';



COMMENT ON COLUMN W83B20T00.TP_DOC_020 IS 'Tipo de documento';



COMMENT ON COLUMN W83B20T00.NUM_REG_020 IS 'Nmero de registro';



COMMENT ON COLUMN W83B20T00.F_REG_020 IS 'Fecha de registro';



COMMENT ON COLUMN W83B20T00.USUARIO_020 IS 'Usuario';



COMMENT ON COLUMN W83B20T00.N_ACTA_020 IS 'Nmero del acta';



COMMENT ON COLUMN W83B20T00.ANO_ACTA_020 IS 'Ao del acta';



COMMENT ON COLUMN W83B20T00.C_TERRIT_020 IS 'Territorio del acta';



COMMENT ON COLUMN W83B20T00.VERSION_020 IS 'Versin';





CREATE OR REPLACE SYNONYM W83B20S00 FOR W83B20T00;





ALTER TABLE W83B20T00 ADD (

  CONSTRAINT PK_W83B20T00 PRIMARY KEY (ID_DOC_020, N_ACTA_020, ANO_ACTA_020, C_TERRIT_020)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B21T00

(

  TP_CONV_021     VARCHAR2(1 BYTE)              NOT NULL,

  TRAB_DESDE_021  NUMBER(5)                     NOT NULL,

  TRAB_HASTA_021  NUMBER(5)                     NOT NULL,

  NUM_DELEG_021   NUMBER(5)                     NOT NULL

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B21T00 IS 'Tabla de nmero mximo de delegados por tipo de convenio y n de trabajadores';



COMMENT ON COLUMN W83B21T00.TP_CONV_021 IS 'Tipo de convenio, A:administrcin, O: otros';



COMMENT ON COLUMN W83B21T00.TRAB_DESDE_021 IS 'Nmero de trabajadores desde';



COMMENT ON COLUMN W83B21T00.TRAB_HASTA_021 IS 'Nmero de trabajadores hasta';



COMMENT ON COLUMN W83B21T00.NUM_DELEG_021 IS 'Nmero de delegados';





CREATE UNIQUE INDEX PK_W83B21T00 ON W83B21T00

(TP_CONV_021, TRAB_DESDE_021, TRAB_HASTA_021)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





CREATE OR REPLACE SYNONYM W83B21S00 FOR W83B21T00;





ALTER TABLE W83B21T00 ADD (

  CONSTRAINT PK_W83B21T00 PRIMARY KEY (TP_CONV_021, TRAB_DESDE_021, TRAB_HASTA_021)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B23T00

(

  C_COLEG_023  NUMBER(3)                        NOT NULL,

  DESC_023     VARCHAR2(250 BYTE),

  DESE_023     VARCHAR2(250 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B23T00 IS 'Tabla de Colegios';



COMMENT ON COLUMN W83B23T00.C_COLEG_023 IS 'Cdigo de colegio';



COMMENT ON COLUMN W83B23T00.DESC_023 IS 'Descripcion de colegio Castellano';



COMMENT ON COLUMN W83B23T00.DESE_023 IS 'Descripcion de colegio en Euskera';





CREATE OR REPLACE SYNONYM W83B23S00 FOR W83B23T00;





ALTER TABLE W83B23T00 ADD (

  CONSTRAINT PK_W83B23T00 PRIMARY KEY (C_COLEG_023)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B24T00

(

  N_ACTA_024    NUMBER(6)                       NOT NULL,

  ANO_ACTA_024  NUMBER(4)                       NOT NULL,

  C_TERRIT_024  VARCHAR2(2 BYTE)                NOT NULL,

  VERSION_024   NUMBER(2)                       NOT NULL,

  C_COLEG_024   NUMBER(3)                       NOT NULL,

  C_SINDI_024   NUMBER(3)                       NOT NULL,

  N_DELH_024    NUMBER(2)                       NOT NULL,

  N_DELM_024    NUMBER(2)                       NOT NULL,

  N_VOTOS_024   NUMBER(4)                       NOT NULL,

  USUA_024      VARCHAR2(10 BYTE),

  FACTU_024     DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B24T00 IS 'Tabla de escrutinio';



COMMENT ON COLUMN W83B24T00.N_ACTA_024 IS 'Nmero de acta';



COMMENT ON COLUMN W83B24T00.ANO_ACTA_024 IS 'Ao del acta';



COMMENT ON COLUMN W83B24T00.C_TERRIT_024 IS 'Territorio del acta';



COMMENT ON COLUMN W83B24T00.VERSION_024 IS 'Versin';



COMMENT ON COLUMN W83B24T00.C_COLEG_024 IS 'cdigo colegio';



COMMENT ON COLUMN W83B24T00.C_SINDI_024 IS 'Cdigo sindicato';



COMMENT ON COLUMN W83B24T00.N_DELH_024 IS 'Nmero de delegados hombres';



COMMENT ON COLUMN W83B24T00.N_DELM_024 IS 'Nmero de delegados mujeres';



COMMENT ON COLUMN W83B24T00.N_VOTOS_024 IS 'Nmero de votos';



COMMENT ON COLUMN W83B24T00.USUA_024 IS 'Usuario modificacin';



COMMENT ON COLUMN W83B24T00.FACTU_024 IS 'Fecha modificacin';





CREATE OR REPLACE SYNONYM W83B24S00 FOR W83B24T00;





ALTER TABLE W83B24T00 ADD (

  CONSTRAINT PK_W83B24T00 PRIMARY KEY (C_SINDI_024, C_COLEG_024, N_ACTA_024, ANO_ACTA_024, C_TERRIT_024, VERSION_024)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B25T00

(

  DNI_025       VARCHAR2(10 BYTE)               NOT NULL,

  N_ACTA_025    NUMBER(6)                       NOT NULL,

  ANO_ACTA_025  NUMBER(4)                       NOT NULL,

  C_TERRIT_025  VARCHAR2(2 BYTE)                NOT NULL,

  VERSION_025   NUMBER(2)                       NOT NULL,

  F_ALTA_025    DATE                            NOT NULL,

  F_BAJA_025    DATE,

  C_SINDI_025   NUMBER(3),

  C_COLEG_025   NUMBER(3),

  NOMBRE_025    VARCHAR2(50 BYTE)               NOT NULL,

  APEL1_025     VARCHAR2(50 BYTE)               NOT NULL,

  APEL2_025     VARCHAR2(50 BYTE)               NOT NULL,

  SEXO_025      VARCHAR2(1 BYTE)                NOT NULL,

  DNI_SUST_025  VARCHAR2(10 BYTE),

  USUA_025      VARCHAR2(10 BYTE),

  CBAJA_025     NUMBER(4),

  FACTU_025     DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B25T00 IS 'Tabla de delegados';



COMMENT ON COLUMN W83B25T00.DNI_025 IS 'DNI del delegado';



COMMENT ON COLUMN W83B25T00.N_ACTA_025 IS 'Nmero de acta';



COMMENT ON COLUMN W83B25T00.ANO_ACTA_025 IS 'Ao del acta';



COMMENT ON COLUMN W83B25T00.C_TERRIT_025 IS 'Territorio del acta';



COMMENT ON COLUMN W83B25T00.VERSION_025 IS 'Versin';



COMMENT ON COLUMN W83B25T00.F_ALTA_025 IS 'Fecha de alta del delegado';



COMMENT ON COLUMN W83B25T00.F_BAJA_025 IS 'Fecha de baja del delegado';



COMMENT ON COLUMN W83B25T00.C_SINDI_025 IS 'Cdigo del sindicato';



COMMENT ON COLUMN W83B25T00.C_COLEG_025 IS 'Cdigo del colegio';



COMMENT ON COLUMN W83B25T00.NOMBRE_025 IS 'Nombre del delegado';



COMMENT ON COLUMN W83B25T00.APEL1_025 IS 'Primer apellido del delegado';



COMMENT ON COLUMN W83B25T00.APEL2_025 IS 'Segundo apellido del delegado';



COMMENT ON COLUMN W83B25T00.SEXO_025 IS 'Sexo del delegado';





COMMENT ON COLUMN W83B25T00.DNI_SUST_025 IS 'DNI del sustituto';



COMMENT ON COLUMN W83B25T00.USUA_025 IS 'Usuario actualizacin';



COMMENT ON COLUMN W83B25T00.CBAJA_025 IS 'Cdigo del motivo de baja';



COMMENT ON COLUMN W83B25T00.FACTU_025 IS 'Fecha de actualizacin';





CREATE OR REPLACE SYNONYM W83B25S00 FOR W83B25T00;





ALTER TABLE W83B25T00 ADD (

  CONSTRAINT PK_W83B25T00 PRIMARY KEY (DNI_025, N_ACTA_025, ANO_ACTA_025, C_TERRIT_025, VERSION_025, F_ALTA_025)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B26T00

(

  CBAJA_026   VARCHAR2(2 BYTE)                  NOT NULL,

  DESC_026    VARCHAR2(250 BYTE)                NOT NULL,

  DESE_026    VARCHAR2(250 BYTE),

  F_BAJA_026  DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B26T00 IS 'Tabla de Motivos de baja de delegados';



COMMENT ON COLUMN W83B26T00.CBAJA_026 IS 'Cdigo de motivo';



COMMENT ON COLUMN W83B26T00.DESC_026 IS 'Descripcion de motivo de baja delegados en Castellano';



COMMENT ON COLUMN W83B26T00.DESE_026 IS 'Descripcion de motivo de baja delegados en Euskera';



COMMENT ON COLUMN W83B26T00.F_BAJA_026 IS 'Fecha de baja';





CREATE OR REPLACE SYNONYM W83B26S00 FOR W83B26T00;





ALTER TABLE W83B26T00 ADD (

  CONSTRAINT PK_W83B26T00 PRIMARY KEY (CBAJA_026)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B27T00

(

  N_PREAVISO_027    NUMBER(6)                   NOT NULL,

  ANO_PREAVISO_027  NUMBER(4)                   NOT NULL,

  C_TERRIT_027      VARCHAR2(2 BYTE)            NOT NULL,

  C_SINDI_027       NUMBER(3)                   NOT NULL

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B27T00 IS 'Tabla de sindicatos por preaviso';



COMMENT ON COLUMN W83B27T00.N_PREAVISO_027 IS 'Nmero del preaviso';



COMMENT ON COLUMN W83B27T00.ANO_PREAVISO_027 IS 'Ao del preaviso';



COMMENT ON COLUMN W83B27T00.C_TERRIT_027 IS 'Territorio del preaviso';



COMMENT ON COLUMN W83B27T00.C_SINDI_027 IS 'Cdigo del sindicato';





CREATE OR REPLACE SYNONYM W83B27S00 FOR W83B27T00;





ALTER TABLE W83B27T00 ADD (

  CONSTRAINT PK_W83B27T00 PRIMARY KEY (N_PREAVISO_027, ANO_PREAVISO_027, C_TERRIT_027, C_SINDI_027)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B29T00

(

  CEMPR_029   NUMBER(2)                         NOT NULL,

  DESC_029    VARCHAR2(250 BYTE)                NOT NULL,

  DESE_029    VARCHAR2(250 BYTE),

  F_BAJA_029  DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B29T00 IS 'Tabla de tipos de empresa';



COMMENT ON COLUMN W83B29T00.CEMPR_029 IS 'Cdigo del tipo de empresa';



COMMENT ON COLUMN W83B29T00.DESC_029 IS 'Descripcion de tipo de empresa en Castellano';



COMMENT ON COLUMN W83B29T00.DESE_029 IS 'Descripcion de tipo de empresa en Euskera';



COMMENT ON COLUMN W83B29T00.F_BAJA_029 IS 'Fecha de baja';





CREATE OR REPLACE SYNONYM W83B29S00 FOR W83B29T00;





ALTER TABLE W83B29T00 ADD (

  CONSTRAINT PK_W83B29T00 PRIMARY KEY (CEMPR_029)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B30T00

(

  C_IMPUG_030  NUMBER(2)                        NOT NULL,

  DESE_030     VARCHAR2(250 BYTE)               NOT NULL,

  DESC_030     VARCHAR2(250 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B30T00 IS 'Tabla de tipos de impugnacin';



COMMENT ON COLUMN W83B30T00.C_IMPUG_030 IS 'Cdigo del tipo de impugnacin';



COMMENT ON COLUMN W83B30T00.DESE_030 IS 'Descripcion de tipo de impugnacin en Euskera';



COMMENT ON COLUMN W83B30T00.DESC_030 IS 'Descripcion de tipo de impugnacin en Castellano';





CREATE OR REPLACE SYNONYM W83B30S00 FOR W83B30T00;





ALTER TABLE W83B30T00 ADD (

  CONSTRAINT PK_W83B30T00 PRIMARY KEY (C_IMPUG_030)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B31T00

(

  CVOZ_031     VARCHAR2(4 BYTE)                 NOT NULL,

  CTIPVOZ_031  VARCHAR2(4 BYTE)                 NOT NULL,

  DESC_031     VARCHAR2(250 BYTE)               NOT NULL,

  DESE_031     VARCHAR2(250 BYTE),

  F_BAJA_031   DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B31T00 IS 'Tabla de voces';



COMMENT ON COLUMN W83B31T00.CVOZ_031 IS 'Cdigo de la voz';



COMMENT ON COLUMN W83B31T00.CTIPVOZ_031 IS 'Cdigo del tipo de voz';



COMMENT ON COLUMN W83B31T00.DESC_031 IS 'Descripcion de la voz en Castellano';



COMMENT ON COLUMN W83B31T00.DESE_031 IS 'Descripcion de la voz en Euskera';



COMMENT ON COLUMN W83B31T00.F_BAJA_031 IS 'Fecha de baja';





CREATE OR REPLACE SYNONYM W83B31S00 FOR W83B31T00;





ALTER TABLE W83B31T00 ADD (

  CONSTRAINT PK_W83B31T00 PRIMARY KEY (CVOZ_031, CTIPVOZ_031)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B32T00

(

  CTIPVOZ_032  VARCHAR2(4 BYTE)                 NOT NULL,

  DESC_032     VARCHAR2(250 BYTE)               NOT NULL,

  DESE_032     VARCHAR2(250 BYTE),

  F_BAJA_032   DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B32T00 IS 'Tabla de tipos de voces';



COMMENT ON COLUMN W83B32T00.CTIPVOZ_032 IS 'Cdigo del tipo de voz';



COMMENT ON COLUMN W83B32T00.DESC_032 IS 'Descripcion del tipo de voz en Castellano';



COMMENT ON COLUMN W83B32T00.DESE_032 IS 'Descripcion del tipo de voz en Euskera';



COMMENT ON COLUMN W83B32T00.F_BAJA_032 IS 'Fecha de baja';





CREATE OR REPLACE SYNONYM W83B32S00 FOR W83B32T00;





ALTER TABLE W83B32T00 ADD (

  CONSTRAINT PK_W83B32T00 PRIMARY KEY (CTIPVOZ_032)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B33T00

(

  ANO_IMPUG_033     NUMBER(4)                   NOT NULL,

  N_IMPUG_033       NUMBER(6)                   NOT NULL,

  C_TERRIT_033      VARCHAR2(2 BYTE)            NOT NULL,

  F_IMPUG_033       DATE,

  N_PREAVISO_033    NUMBER(6),

  ANO_PREAVISO_033  NUMBER(4),

  N_ACTA_033        NUMBER(6),

  ANO_ACTA_033      NUMBER(4),

  VERSION_033       NUMBER(2),

  DNI_033           VARCHAR2(10 BYTE),

  C_IMPUG_033       NUMBER(2),

  FENVARB_033       DATE,

  FDESES_033        DATE,

  FENVJUZ_033       DATE,

  F_SENTEN_033      DATE,

  RESULT_033        VARCHAR2(1 BYTE),

  ASUNTO_033        VARCHAR2(500 BYTE),

  DECISIOB_033      VARCHAR2(500 BYTE),

  USUA_033          VARCHAR2(10 BYTE),

  FACTU_033         DATE,

  TEXTOLAUDO_033    VARCHAR2(2000 BYTE),

  N_REGIS_033       VARCHAR2(15 BYTE),

  F_REGIS_033       DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B33T00 IS 'Tabla de impugnaciones';



COMMENT ON COLUMN W83B33T00.ANO_IMPUG_033 IS 'Ao de la impugnacin';



COMMENT ON COLUMN W83B33T00.N_IMPUG_033 IS 'Nmero de la impugnacin';



COMMENT ON COLUMN W83B33T00.C_TERRIT_033 IS 'Territorio';



COMMENT ON COLUMN W83B33T00.F_IMPUG_033 IS 'fecha de la impugnacin';



COMMENT ON COLUMN W83B33T00.N_PREAVISO_033 IS 'Nmero de preaviso';



COMMENT ON COLUMN W83B33T00.ANO_PREAVISO_033 IS 'Ao del preaviso';



COMMENT ON COLUMN W83B33T00.N_ACTA_033 IS 'Nmero de acta';



COMMENT ON COLUMN W83B33T00.ANO_ACTA_033 IS 'Ao del acta';



COMMENT ON COLUMN W83B33T00.DNI_033 IS 'DNI';



COMMENT ON COLUMN W83B33T00.C_IMPUG_033 IS 'Cdigo tipo de impugnacin';



COMMENT ON COLUMN W83B33T00.FENVARB_033 IS 'Fecha envo al rbitro';



COMMENT ON COLUMN W83B33T00.FDESES_033 IS 'Fecha baja deset.';



COMMENT ON COLUMN W83B33T00.FENVJUZ_033 IS 'Fecha envo juzgado';



COMMENT ON COLUMN W83B33T00.F_SENTEN_033 IS 'Fecha de sentencia';



COMMENT ON COLUMN W83B33T00.RESULT_033 IS 'Resultado';



COMMENT ON COLUMN W83B33T00.ASUNTO_033 IS 'Asunto';



COMMENT ON COLUMN W83B33T00.DECISIOB_033 IS 'Decisin';



COMMENT ON COLUMN W83B33T00.USUA_033 IS 'Usuario actualizacin';



COMMENT ON COLUMN W83B33T00.FACTU_033 IS 'Fecha de actualizacin';



COMMENT ON COLUMN W83B33T00.TEXTOLAUDO_033 IS 'Texto laudo';



COMMENT ON COLUMN W83B33T00.N_REGIS_033 IS 'Nmero de registro';



COMMENT ON COLUMN W83B33T00.F_REGIS_033 IS 'Fecha de registro';





CREATE OR REPLACE SYNONYM W83B33S00 FOR W83B33T00;





ALTER TABLE W83B33T00 ADD (

  CONSTRAINT PK_W83B33T00 PRIMARY KEY (N_IMPUG_033, ANO_IMPUG_033, C_TERRIT_033)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B34T00

(

  N_IMPUG_034    NUMBER(6)                      NOT NULL,

  ANO_IMPUG_034  NUMBER(4)                      NOT NULL,

  C_TERRIT_034   VARCHAR2(2 BYTE)               NOT NULL,

  N_LAUDO_034    NUMBER(3)                      NOT NULL,

  ANO_LAUDO_034  NUMBER(4)                      NOT NULL,

  CVOZ_034       VARCHAR2(2 BYTE)               NOT NULL,

  CTIPVOZ_034    VARCHAR2(2 BYTE)               NOT NULL,

  SINO_034       NUMBER(1)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B34T00 IS 'Tabla de voces de una impugnacin';



COMMENT ON COLUMN W83B34T00.N_IMPUG_034 IS 'Nmero de  impugnacion';



COMMENT ON COLUMN W83B34T00.ANO_IMPUG_034 IS 'Ao de  impugnacion';



COMMENT ON COLUMN W83B34T00.C_TERRIT_034 IS 'Territorio';



COMMENT ON COLUMN W83B34T00.N_LAUDO_034 IS 'Nmero de laudo';



COMMENT ON COLUMN W83B34T00.ANO_LAUDO_034 IS 'Ao de laudo';



COMMENT ON COLUMN W83B34T00.CVOZ_034 IS 'Voz';



COMMENT ON COLUMN W83B34T00.CTIPVOZ_034 IS 'Tipo de voz';



COMMENT ON COLUMN W83B34T00.SINO_034 IS 'Si/No';





CREATE OR REPLACE SYNONYM W83B34S00 FOR W83B34T00;





ALTER TABLE W83B34T00 ADD (

  CONSTRAINT PK_W83B34T00 PRIMARY KEY (N_IMPUG_034, ANO_IMPUG_034, C_TERRIT_034, N_LAUDO_034, ANO_LAUDO_034, CVOZ_034, CTIPVOZ_034)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B35T00

(

  N_IMPUG_035    NUMBER(6)                      NOT NULL,

  ANO_IMPUG_035  NUMBER(4)                      NOT NULL,

  C_TERRIT_035   VARCHAR2(2 BYTE)               NOT NULL,

  C_SINDI_035    NUMBER(3)                      NOT NULL

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B35T00 IS 'Tabla de sindicatos por impugnacin';



COMMENT ON COLUMN W83B35T00.N_IMPUG_035 IS 'Nmero de impugnacion';



COMMENT ON COLUMN W83B35T00.ANO_IMPUG_035 IS 'Ao de impugnacin';



COMMENT ON COLUMN W83B35T00.C_TERRIT_035 IS 'Territorio';



COMMENT ON COLUMN W83B35T00.C_SINDI_035 IS 'Cdigo del sindicato';





CREATE OR REPLACE SYNONYM W83B35S00 FOR W83B35T00;





ALTER TABLE W83B35T00 ADD (

  CONSTRAINT PK_W83B35T00 PRIMARY KEY (N_IMPUG_035, ANO_IMPUG_035, C_TERRIT_035, C_SINDI_035)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B36T00

(

  DNI_036       VARCHAR2(10 BYTE)               NOT NULL,

  C_TERRIT_036  VARCHAR2(2 BYTE)                NOT NULL,

  NOMBRE_036    VARCHAR2(250 BYTE)              NOT NULL,

  F_BAJA_036    DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B36T00 IS 'Tabla de rbitros';



COMMENT ON COLUMN W83B36T00.DNI_036 IS 'DNI del rbitro';



COMMENT ON COLUMN W83B36T00.C_TERRIT_036 IS 'Cdigo del territorio';



COMMENT ON COLUMN W83B36T00.NOMBRE_036 IS 'Nombre del rbitro';



COMMENT ON COLUMN W83B36T00.F_BAJA_036 IS 'Fecha de baja';





CREATE OR REPLACE SYNONYM W83B36S00 FOR W83B36T00;





ALTER TABLE W83B36T00 ADD (

  CONSTRAINT PK_W83B36T00 PRIMARY KEY (DNI_036, C_TERRIT_036)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B37T00

(

  N_PREAVISO_037     NUMBER(6)                  NOT NULL,

  ANO_PREAVISO_037   NUMBER(4)                  NOT NULL,

  C_TERRIT_037       VARCHAR2(2 BYTE),

  ID_CENTRO_037      NUMBER(6)                  NOT NULL,

  C_CONV_037         NUMBER(4),

  F_ENTRA_037        DATE                       NOT NULL,

  F_INICIO_037       DATE                       NOT NULL,

  S_PARCIAL_037      VARCHAR2(1 BYTE)           NOT NULL,

  GLOBAL_037         VARCHAR2(1 BYTE)           NOT NULL,

  ADMONEMP_037       VARCHAR2(1 BYTE),

  F_ELECC_037        DATE,

  F_REGIS_037        DATE,

  N_REGIS_037        VARCHAR2(15 BYTE),

  ANO_ACTA_037       NUMBER(4),

  N_ACTA_037         NUMBER(6),

  OBSERV_037         VARCHAR2(500 BYTE),

  USUA_037           VARCHAR2(10 BYTE),

  FACTU_037          DATE,

  CONVACU_037        NUMBER(4),

  N_CENAFEC_037      NUMBER(6),

  FENVIO_037         DATE,

  USUENV_037         VARCHAR2(10 BYTE),

  NCARPPROCELEC_037  NUMBER(10),

  OID8501_037        NUMBER(13),

  NOP_037            NUMBER(3),

  NDF_037            VARCHAR2(29 BYTE),

  DIR_ALT_037        VARCHAR2(200 BYTE),

  MUN_ALT_037        VARCHAR2(3 BYTE),

  PROV_ALT_037       VARCHAR2(2 BYTE),

  CODPOS_ALT_037     VARCHAR2(5 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B37T00 IS 'Tabla de Preavisos';



COMMENT ON COLUMN W83B37T00.CODPOS_ALT_037 IS 'Cdigo postal';



COMMENT ON COLUMN W83B37T00.DIR_ALT_037 IS 'Direccin alternativa';



COMMENT ON COLUMN W83B37T00.MUN_ALT_037 IS 'Municipio alternativo';



COMMENT ON COLUMN W83B37T00.PROV_ALT_037 IS 'Provincia alternativa';



COMMENT ON COLUMN W83B37T00.N_ACTA_037 IS 'Nmero del acta';



COMMENT ON COLUMN W83B37T00.OBSERV_037 IS 'Observaciones';



COMMENT ON COLUMN W83B37T00.USUA_037 IS 'Usuario de modificacin';



COMMENT ON COLUMN W83B37T00.FACTU_037 IS 'Fecha de modificacin';



COMMENT ON COLUMN W83B37T00.CONVACU_037 IS '????Estaba de antes, de momento no lo usamos';



COMMENT ON COLUMN W83B37T00.N_CENAFEC_037 IS 'Nmero de centro afecta';



COMMENT ON COLUMN W83B37T00.FENVIO_037 IS 'Fecha de envo (de momento no lo usamos)';



COMMENT ON COLUMN W83B37T00.USUENV_037 IS 'Usuario de envo (de momento no lo usamos)';



COMMENT ON COLUMN W83B37T00.NCARPPROCELEC_037 IS 'Nmero de carpeta del proceso electoral (de momento no lo usamos)';



COMMENT ON COLUMN W83B37T00.OID8501_037 IS '??????';



COMMENT ON COLUMN W83B37T00.NOP_037 IS 'Nmero de orden del preaviso (de momento no lo usamos)';



COMMENT ON COLUMN W83B37T00.NDF_037 IS 'Nmero de fichero (de momento no lo usamos)';



COMMENT ON COLUMN W83B37T00.N_PREAVISO_037 IS 'nmero de preaviso';



COMMENT ON COLUMN W83B37T00.ANO_PREAVISO_037 IS 'Ao preaviso';



COMMENT ON COLUMN W83B37T00.C_TERRIT_037 IS 'Territorio';



COMMENT ON COLUMN W83B37T00.ID_CENTRO_037 IS 'NIF Centro de trabajo';



COMMENT ON COLUMN W83B37T00.F_ENTRA_037 IS 'Fecha de entrada';



COMMENT ON COLUMN W83B37T00.F_INICIO_037 IS 'Fecha de inicio';



COMMENT ON COLUMN W83B37T00.S_PARCIAL_037 IS 'Eleccion parcial';



COMMENT ON COLUMN W83B37T00.GLOBAL_037 IS 'eleccin global';



COMMENT ON COLUMN W83B37T00.ADMONEMP_037 IS '1 si es empresa, 2 si es administracin';



COMMENT ON COLUMN W83B37T00.F_ELECC_037 IS 'Fecha de la eleccin';



COMMENT ON COLUMN W83B37T00.F_REGIS_037 IS 'Fecha de registro';



COMMENT ON COLUMN W83B37T00.N_REGIS_037 IS 'Nmero de registro';



COMMENT ON COLUMN W83B37T00.ANO_ACTA_037 IS 'Ao del acta';





CREATE OR REPLACE SYNONYM W83B37S00 FOR W83B37T00;





ALTER TABLE W83B37T00 ADD (

  CONSTRAINT PK_W83B37T00 PRIMARY KEY (N_PREAVISO_037, ANO_PREAVISO_037, C_TERRIT_037)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B38T00

(

  ID_DOC_038        NUMBER(7)                   NOT NULL,

  ANO_PREAVISO_038  NUMBER(4)                   NOT NULL,

  N_PREAVISO_038    NUMBER(6)                   NOT NULL,

  C_TERRIT_038      VARCHAR2(2 BYTE)            NOT NULL,

  C_TRAM_038        NUMBER(4)                   NOT NULL,

  C_FASE_038        NUMBER(4)                   NOT NULL,

  NOMB_DOCU_038     VARCHAR2(100 BYTE),

  LONG_DOCU_038     NUMBER(10),

  DOCUMENTO_038     BLOB,

  TP_DOC_038        NUMBER(3),

  NUM_REG_038       VARCHAR2(15 BYTE),

  F_REG_038         DATE,

  USUARIO_038       VARCHAR2(100 BYTE),

  F_ACTU_038        DATE

)

TABLESPACE W8311E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

LOB (DOCUMENTO_038) STORE AS 

      ( TABLESPACE  W8311E00 

        DISABLE     STORAGE IN ROW

        CHUNK       8192

        PCTVERSION  0

        NOCACHE

        STORAGE    (

                    INITIAL          64K

                    NEXT             128K

                    MINEXTENTS       1

                    MAXEXTENTS       2147483645

                    PCTINCREASE      0

                    BUFFER_POOL      DEFAULT

                   )

      )

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B38T00 IS 'Tabla de documentos adjuntos al preaviso';



COMMENT ON COLUMN W83B38T00.ANO_PREAVISO_038 IS 'Ao del preaviso';



COMMENT ON COLUMN W83B38T00.N_PREAVISO_038 IS 'Nmero del preaviso';



COMMENT ON COLUMN W83B38T00.C_TERRIT_038 IS 'Territorio del preaviso';



COMMENT ON COLUMN W83B38T00.NOMB_DOCU_038 IS 'Nombre del documento';



COMMENT ON COLUMN W83B38T00.LONG_DOCU_038 IS 'Longitud del documento';



COMMENT ON COLUMN W83B38T00.DOCUMENTO_038 IS 'Documento';



COMMENT ON COLUMN W83B38T00.TP_DOC_038 IS 'Tipo del documento';



COMMENT ON COLUMN W83B38T00.NUM_REG_038 IS 'Nmero de registro';



COMMENT ON COLUMN W83B38T00.F_REG_038 IS 'Fecha de registro';



COMMENT ON COLUMN W83B38T00.USUARIO_038 IS 'Usuario';





CREATE OR REPLACE SYNONYM W83B38S00 FOR W83B38T00;





ALTER TABLE W83B38T00 ADD (

  CONSTRAINT PK_W83B38T00 PRIMARY KEY (ID_DOC_038, N_PREAVISO_038, ANO_PREAVISO_038, C_TERRIT_038)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



			   

			   

			   



/* **************************************************************************************************** */

CREATE TABLE W83B39T00

(

  CPERF_039         VARCHAR2(2 BYTE)            NOT NULL,

  PPERFIL_SSCC_039  VARCHAR2(1 BYTE)            DEFAULT 0,

  PDES_039          VARCHAR2(250 BYTE)          NOT NULL,

  PDESE_039         VARCHAR2(250 BYTE)          NOT NULL

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            MINEXTENTS       1

            MAXEXTENTS       UNLIMITED

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;





CREATE UNIQUE INDEX PK_W83B39T00 ON W83B39T00

(CPERF_039)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            MINEXTENTS       1

            MAXEXTENTS       UNLIMITED

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;











CREATE OR REPLACE SYNONYM W83B39S00 FOR W83B39T00;





ALTER TABLE W83B39T00 ADD (

  CONSTRAINT PK_W83B39T00

 PRIMARY KEY

 (CPERF_039)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                MINEXTENTS       1

                MAXEXTENTS       UNLIMITED

                PCTINCREASE      0

               ));

		   

/* **************************************************************************************************** */



			   

			   

CREATE TABLE W83B40T00 

(	

	CRESP_040 	VARCHAR2(2 BYTE) NOT NULL , 

	NOMRESP_040 VARCHAR2(80 BYTE), 

	C_TERRIT_040 VARCHAR2(2 BYTE), 

	PERFIL_040 VARCHAR2(3 BYTE), 

	F_BAJA_040 DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;	

	



COMMENT ON TABLE W83B40T00 IS 'Tabla de responsables de rea';



COMMENT ON COLUMN W83B40T00.CRESP_040 IS 'Cdigo del responsable';



COMMENT ON COLUMN W83B40T00.NOMRESP_040 IS 'Nombre del responsable';



COMMENT ON COLUMN W83B40T00.C_TERRIT_040 IS 'Cdigo del territorio';



COMMENT ON COLUMN W83B40T00.PERFIL_040 IS 'Perfil del responsable';



COMMENT ON COLUMN W83B40T00.F_BAJA_040 IS 'Fecha de baja';





CREATE OR REPLACE SYNONYM W83B40S00 FOR W83B40T00;





ALTER TABLE W83B40T00 ADD (

  CONSTRAINT PK_W83B40T00 PRIMARY KEY (CRESP_040)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B41T00

(

  ID_DOC_041     NUMBER(7)                      NOT NULL,

  N_IMPUG_041    NUMBER(6)                      NOT NULL,

  ANO_IMPUG_041  NUMBER(4)                      NOT NULL,

  C_TERRIT_041   VARCHAR2(2 BYTE)               NOT NULL,

  C_TRAM_041     NUMBER(4)                      NOT NULL,

  C_FASE_041     NUMBER(4)                      NOT NULL,

  NOMB_DOCU_041  VARCHAR2(100 BYTE),

  LONG_DOCU_041  NUMBER(10),

  DOCUMENTO_041  BLOB,

  TP_DOC_041     NUMBER(3),

  NUM_REG_041    VARCHAR2(15 BYTE),

  F_REG_041      DATE,

  USUARIO_041    VARCHAR2(100 BYTE),

  F_ACTU_041     DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

LOB (DOCUMENTO_041) STORE AS 

      ( TABLESPACE  W8301E00 

        DISABLE     STORAGE IN ROW

        CHUNK       8192

        PCTVERSION  0

        NOCACHE

        STORAGE    (

                    INITIAL          64K

                    NEXT             128K

                    MINEXTENTS       1

                    MAXEXTENTS       2147483645

                    PCTINCREASE      0

                    BUFFER_POOL      DEFAULT

                   )

      )

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B41T00 IS 'Tabla de documentos adjuntos a la impugnacin';



COMMENT ON COLUMN W83B41T00.N_IMPUG_041 IS 'Nmero de la impugnacin';



COMMENT ON COLUMN W83B41T00.ANO_IMPUG_041 IS 'Ao de la impugnacin';



COMMENT ON COLUMN W83B41T00.C_TERRIT_041 IS 'Territorio de la impugnacin';



COMMENT ON COLUMN W83B41T00.NOMB_DOCU_041 IS 'Nombre del documento';



COMMENT ON COLUMN W83B41T00.LONG_DOCU_041 IS 'Longitud del documento';



COMMENT ON COLUMN W83B41T00.DOCUMENTO_041 IS 'Documento';



COMMENT ON COLUMN W83B41T00.TP_DOC_041 IS 'Tipo de documento';



COMMENT ON COLUMN W83B41T00.NUM_REG_041 IS 'Nmero de registro';



COMMENT ON COLUMN W83B41T00.F_REG_041 IS 'Fecha de registro';



COMMENT ON COLUMN W83B41T00.USUARIO_041 IS 'Usuario';





CREATE OR REPLACE SYNONYM W83B41S00 FOR W83B41T00;





ALTER TABLE W83B41T00 ADD (

  CONSTRAINT PK_W83B41T00 PRIMARY KEY (ID_DOC_041, N_IMPUG_041, ANO_IMPUG_041, C_TERRIT_041)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B42T00

(

  ANO_CIERRE_042  NUMBER(4)                     NOT NULL,

  MES_CIERRE_042  NUMBER(2)                     NOT NULL,

  CIERRE_01_042   VARCHAR2(1 BYTE),

  CIERRE_20_042   VARCHAR2(1 BYTE),

  CIERRE_48_042   VARCHAR2(1 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B42T00 IS 'Tabla del Cierre Mensual';



COMMENT ON COLUMN W83B42T00.ANO_CIERRE_042 IS 'Ao del cierre';



COMMENT ON COLUMN W83B42T00.MES_CIERRE_042 IS 'Mes del cierre';



COMMENT ON COLUMN W83B42T00.CIERRE_01_042 IS 'Cierre lava';



COMMENT ON COLUMN W83B42T00.CIERRE_20_042 IS 'Cierre Gipuzkoa';



COMMENT ON COLUMN W83B42T00.CIERRE_48_042 IS 'Cierre Bizkaia';





CREATE OR REPLACE SYNONYM W83B42S00 FOR W83B42T00;





ALTER TABLE W83B42T00 ADD (

  CONSTRAINT PK_W83B42T00 PRIMARY KEY (MES_CIERRE_042, ANO_CIERRE_042)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B44T00

(

  N_ACTA_044    NUMBER(6)                       NOT NULL,

  ANO_ACTA_044  NUMBER(4)                       NOT NULL,

  C_TERRIT_044  VARCHAR2(2 BYTE)                NOT NULL,

  VERSION_044   NUMBER(2)                       NOT NULL,

  C_COLEG_044   NUMBER(3)                       NOT NULL,

  PAP_VAL_044   NUMBER(6),

  PAP_NUL_044   NUMBER(6),

  PAP_BLA_044   NUMBER(6),

  ELEC_044      NUMBER(6),

  VOTA_044      NUMBER(6)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B44T00 IS 'Tabla de papeletas';



COMMENT ON COLUMN W83B44T00.N_ACTA_044 IS 'Nmero de acta';



COMMENT ON COLUMN W83B44T00.ANO_ACTA_044 IS 'Ao de acta';



COMMENT ON COLUMN W83B44T00.C_TERRIT_044 IS 'Territorio';



COMMENT ON COLUMN W83B44T00.VERSION_044 IS 'Versin del acta';



COMMENT ON COLUMN W83B44T00.C_COLEG_044 IS 'Cdigo colegio';



COMMENT ON COLUMN W83B44T00.PAP_VAL_044 IS 'Papeletas vlidas';



COMMENT ON COLUMN W83B44T00.PAP_NUL_044 IS 'Papeletas nulas';



COMMENT ON COLUMN W83B44T00.PAP_BLA_044 IS 'Papeletas blancas';



COMMENT ON COLUMN W83B44T00.ELEC_044 IS 'Electores';



COMMENT ON COLUMN W83B44T00.VOTA_044 IS 'Votantes';





CREATE OR REPLACE SYNONYM W83B44S00 FOR W83B44T00;





ALTER TABLE W83B44T00 ADD (

  CONSTRAINT PK_W83B44T00 PRIMARY KEY (N_ACTA_044, ANO_ACTA_044, C_TERRIT_044, C_COLEG_044, VERSION_044)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));





/* **************************************************************************************************** */



CREATE TABLE W83B51T00

(

  C_TERRIT_051     VARCHAR2(2 BYTE)             NOT NULL,

  TELEFONO1_051    NUMBER(9),

  TELEFONO2_O51    NUMBER(9),

  FAX_051          NUMBER(9),

  DEL_TERRIT_051   VARCHAR2(150 BYTE),

  SEC_GENERAL_051  VARCHAR2(150 BYTE),

  CALLE_051        VARCHAR2(250 BYTE),

  NUM_051          NUMBER(3),

  PISO_051         NUMBER(2),

  LETRA_051        VARCHAR2(10 BYTE),

  CP_051           VARCHAR2(5 BYTE),

  LOCALIDAD_051    VARCHAR2(3 BYTE),

  REG_MANUAL_051   VARCHAR2(1 BYTE)             DEFAULT 0,

  NUMMOD_051       NUMBER(8),

  NUMMODSAL_051    NUMBER(8),

  C_TERRIT2_051    VARCHAR2(2 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B51T00 IS 'Tabla de delegaciones';



COMMENT ON COLUMN W83B51T00.REG_MANUAL_051 IS 'Registro de entrada: 0 automtico, 1 manual';



COMMENT ON COLUMN W83B51T00.NUMMOD_051 IS 'Nmero modelo registro de entrada';



COMMENT ON COLUMN W83B51T00.NUMMODSAL_051 IS 'Nmero modelo registro de salida';



COMMENT ON COLUMN W83B51T00.C_TERRIT2_051 IS 'Territorio para saber donde estn SSCC';



COMMENT ON COLUMN W83B51T00.C_TERRIT_051 IS 'Cdigo del territorio';



COMMENT ON COLUMN W83B51T00.TELEFONO1_051 IS 'Telfono 1';



COMMENT ON COLUMN W83B51T00.TELEFONO2_O51 IS 'Telfono 2';



COMMENT ON COLUMN W83B51T00.FAX_051 IS 'Fax';



COMMENT ON COLUMN W83B51T00.DEL_TERRIT_051 IS 'Delegado Territorial';



COMMENT ON COLUMN W83B51T00.SEC_GENERAL_051 IS 'Secretario general';



COMMENT ON COLUMN W83B51T00.CALLE_051 IS 'Calle';



COMMENT ON COLUMN W83B51T00.NUM_051 IS 'Nmero';



COMMENT ON COLUMN W83B51T00.PISO_051 IS 'Piso';



COMMENT ON COLUMN W83B51T00.LETRA_051 IS 'Letra';



COMMENT ON COLUMN W83B51T00.CP_051 IS 'Cdigo postal';



COMMENT ON COLUMN W83B51T00.LOCALIDAD_051 IS 'Localidad';





CREATE OR REPLACE SYNONYM W83B51S00 FOR W83B51T00;





ALTER TABLE W83B51T00 ADD (

  CONSTRAINT PK_W83B51T00 PRIMARY KEY (C_TERRIT_051)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B52T00

(

  C_FASE_052  NUMBER(4)                         NOT NULL,

  DESC_052    VARCHAR2(250 BYTE)                NOT NULL,

  DESE_052    VARCHAR2(250 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B52T00 IS 'Tabla de Fases';



COMMENT ON COLUMN W83B52T00.C_FASE_052 IS 'Codigo de fase';



COMMENT ON COLUMN W83B52T00.DESC_052 IS 'Descripcion de fase en Castellano';



COMMENT ON COLUMN W83B52T00.DESE_052 IS 'Descripcion de fase en Euskera';





CREATE OR REPLACE SYNONYM W83B52S00 FOR W83B52T00;





ALTER TABLE W83B52T00 ADD (

  CONSTRAINT PK_W83B52T00 PRIMARY KEY (C_FASE_052)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B53T00

(

  ANO_PREAVISO_053   NUMBER(4)                  NOT NULL,

  N_PREAVISO_053     NUMBER(6)                  NOT NULL,

  C_TERRIT_053       VARCHAR2(2 BYTE)           NOT NULL,

  C_CONV_053         NUMBER(4),

  F_INICIO_053       DATE                       NOT NULL,

  F_ELECC_053        DATE,

  S_PARCIAL_053      VARCHAR2(1 BYTE),

  GLOBAL_053         VARCHAR2(1 BYTE),

  OBSERV_053         VARCHAR2(500 BYTE),

  USUA_053           VARCHAR2(10 BYTE),

  FACTU_053          DATE,

  CONVACU_053        NUMBER(4),

  ADMONEMP_053       VARCHAR2(1 BYTE),

  N_CENAFEC_053      NUMBER(6),

  FENVIO_053         DATE,

  USUENV_053         VARCHAR2(10 BYTE),

  NCARPPROCELEC_053  NUMBER(10),

  OID8501_053        NUMBER(13),

  NOP_053            NUMBER(3),

  NDF_053            VARCHAR2(29 BYTE),

  DIR_ALT_053        VARCHAR2(200 BYTE),

  MUN_ALT_053        VARCHAR2(3 BYTE),

  PROV_ALT_053       VARCHAR2(2 BYTE),

  NIF_CENTRO_053     VARCHAR2(10 BYTE),

  NUM_CENTRO_053     NUMBER(4),

  RAZ_SOCIAL_053     VARCHAR2(200 BYTE),

  CODPOS_ALT_053     VARCHAR2(5 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B53T00 IS 'Tabla de Preavisos Originales';



COMMENT ON COLUMN W83B53T00.CODPOS_ALT_053 IS 'Cdigo postal';



COMMENT ON COLUMN W83B53T00.NIF_CENTRO_053 IS 'Centro de trabajo';



COMMENT ON COLUMN W83B53T00.NUM_CENTRO_053 IS 'Nmero Centro de trabajo';



COMMENT ON COLUMN W83B53T00.RAZ_SOCIAL_053 IS 'Razn social';



COMMENT ON COLUMN W83B53T00.ANO_PREAVISO_053 IS 'Ao preaviso original';



COMMENT ON COLUMN W83B53T00.N_PREAVISO_053 IS 'nmero de preaviso original';



COMMENT ON COLUMN W83B53T00.C_TERRIT_053 IS 'Territorio';



COMMENT ON COLUMN W83B53T00.F_INICIO_053 IS 'Fecha de inicio';



COMMENT ON COLUMN W83B53T00.F_ELECC_053 IS 'Fecha de la eleccin';



COMMENT ON COLUMN W83B53T00.S_PARCIAL_053 IS 'Eleccion parcial';



COMMENT ON COLUMN W83B53T00.GLOBAL_053 IS 'eleccin global';



COMMENT ON COLUMN W83B53T00.OBSERV_053 IS 'Observaciones';



COMMENT ON COLUMN W83B53T00.USUA_053 IS 'Usuario de modificacin';



COMMENT ON COLUMN W83B53T00.FACTU_053 IS 'Fecha de modificacin';



COMMENT ON COLUMN W83B53T00.CONVACU_053 IS '????Estaba de antes, de momento no lo usamos';



COMMENT ON COLUMN W83B53T00.ADMONEMP_053 IS '1 si es empresa, 2 si es administracin';



COMMENT ON COLUMN W83B53T00.N_CENAFEC_053 IS 'Nmero de centro afecta';



COMMENT ON COLUMN W83B53T00.FENVIO_053 IS 'Fecha de envo (de momento no lo usamos)';



COMMENT ON COLUMN W83B53T00.USUENV_053 IS 'Usuario de envo (de momento no lo usamos)';



COMMENT ON COLUMN W83B53T00.NCARPPROCELEC_053 IS 'Nmero de carpeta del proceso electoral (de momento no lo usamos)';



COMMENT ON COLUMN W83B53T00.OID8501_053 IS '??????';



COMMENT ON COLUMN W83B53T00.NOP_053 IS 'Nmero de orden del preaviso (de momento no lo usamos)';



COMMENT ON COLUMN W83B53T00.NDF_053 IS 'Nmero de fichero (de momento no lo usamos)';





CREATE OR REPLACE SYNONYM W83B53S00 FOR W83B53T00;





ALTER TABLE W83B53T00 ADD (

  CONSTRAINT PK_W83B53T00 PRIMARY KEY (N_PREAVISO_053, ANO_PREAVISO_053, C_TERRIT_053)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B54T00

(

  N_PREAVISO_054    NUMBER(6)                   NOT NULL,

  ANO_PREAVISO_054  NUMBER(4)                   NOT NULL,

  C_TERRIT_054      VARCHAR2(2 BYTE)            NOT NULL,

  C_SINDI_054       NUMBER(3)                   NOT NULL

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B54T00 IS 'Tabla de sindicatos por preaviso original';



COMMENT ON COLUMN W83B54T00.N_PREAVISO_054 IS 'Nmero del preaviso';



COMMENT ON COLUMN W83B54T00.ANO_PREAVISO_054 IS 'Ao del preaviso';



COMMENT ON COLUMN W83B54T00.C_TERRIT_054 IS 'Territorio del preaviso';



COMMENT ON COLUMN W83B54T00.C_SINDI_054 IS 'Cdigo del sindicato';





CREATE OR REPLACE SYNONYM W83B54S00 FOR W83B54T00;





ALTER TABLE W83B54T00 ADD (

  CONSTRAINT PK_W83B54T00 PRIMARY KEY (N_PREAVISO_054, ANO_PREAVISO_054, C_TERRIT_054, C_SINDI_054)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B55T00

(

  N_PREAVISO_055    NUMBER(6)                   NOT NULL,

  ANO_PREAVISO_055  NUMBER(4)                   NOT NULL,

  C_TERRIT_055      VARCHAR2(2 BYTE)            NOT NULL,

  FACTU_055         DATE                        NOT NULL,

  USUA_055          VARCHAR2(10 BYTE)           NOT NULL,

  DESC_CAS_055      VARCHAR2(250 BYTE)          NOT NULL,

  DESC_EUS_055      VARCHAR2(250 BYTE)          NOT NULL

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B55T00 IS 'Tabla historial de preavisos';



COMMENT ON COLUMN W83B55T00.N_PREAVISO_055 IS 'Nmero del preaviso';



COMMENT ON COLUMN W83B55T00.ANO_PREAVISO_055 IS 'Ao del preaviso';



COMMENT ON COLUMN W83B55T00.C_TERRIT_055 IS 'Territorio del preaviso';



COMMENT ON COLUMN W83B55T00.FACTU_055 IS 'Fecha de actualizacin';



COMMENT ON COLUMN W83B55T00.USUA_055 IS 'usuario de actualizacin';



COMMENT ON COLUMN W83B55T00.DESC_CAS_055 IS 'Descripcin de la accin en castellano';



COMMENT ON COLUMN W83B55T00.DESC_EUS_055 IS 'Descripcin de la accin en euskera';





CREATE OR REPLACE SYNONYM W83B55S00 FOR W83B55T00;



/* **************************************************************************************************** */



CREATE TABLE W83B56T00

(

  N_PREAVISO_056    NUMBER(6)                   NOT NULL,

  ANO_PREAVISO_056  NUMBER(4)                   NOT NULL,

  C_TERRIT_056      VARCHAR2(2 BYTE)            NOT NULL,

  C_TRAM_056        NUMBER(4)                   NOT NULL,

  C_FASE_056        NUMBER(4)                   NOT NULL,

  F_ACTU_056        DATE                        NOT NULL,

  USUA_056          VARCHAR2(10 BYTE)           NOT NULL,

  F_REG_SAL_056     DATE,

  N_REG_SAL_056     VARCHAR2(15 BYTE),

  F_NOTIF_056       DATE,

  F_EXPIR_056       DATE,

  F_MODIF_056       DATE,

  USU_MOD_056       VARCHAR2(10 BYTE),

  F_TRAM_056        DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B56T00 IS 'Tabla de historial tramitacin preavisos';



COMMENT ON COLUMN W83B56T00.F_MODIF_056 IS 'Fecha de modificacin';



COMMENT ON COLUMN W83B56T00.USU_MOD_056 IS 'Usuario de modificacin';



COMMENT ON COLUMN W83B56T00.N_PREAVISO_056 IS 'Nmero del preaviso';



COMMENT ON COLUMN W83B56T00.ANO_PREAVISO_056 IS 'Ao del preaviso';



COMMENT ON COLUMN W83B56T00.C_TERRIT_056 IS 'Territorio del preaviso';



COMMENT ON COLUMN W83B56T00.C_TRAM_056 IS 'Trmite del preaviso';



COMMENT ON COLUMN W83B56T00.C_FASE_056 IS 'Fase del preaviso';



COMMENT ON COLUMN W83B56T00.F_ACTU_056 IS 'Fecha en la que el preaviso apsa por esa fase/trmite';



COMMENT ON COLUMN W83B56T00.USUA_056 IS 'Usuario';



COMMENT ON COLUMN W83B56T00.F_REG_SAL_056 IS 'Fecha del registro de salida';



COMMENT ON COLUMN W83B56T00.N_REG_SAL_056 IS 'Nmero del registro de salida';



COMMENT ON COLUMN W83B56T00.F_NOTIF_056 IS 'Fecha de notificacin';



COMMENT ON COLUMN W83B56T00.F_EXPIR_056 IS 'Fechad e expiracin';





CREATE OR REPLACE SYNONYM W83B56S00 FOR W83B56T00;





ALTER TABLE W83B56T00 ADD (

  CONSTRAINT PK_W83B56T00 PRIMARY KEY (N_PREAVISO_056, ANO_PREAVISO_056, C_TERRIT_056, C_TRAM_056, C_FASE_056, F_ACTU_056)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B57T00

(

  N_ACTA_057    NUMBER(6)                       NOT NULL,

  ANO_ACTA_057  NUMBER(4)                       NOT NULL,

  C_TERRIT_057  VARCHAR2(2 BYTE)                NOT NULL,

  FACTU_057     DATE                            NOT NULL,

  USUA_057      VARCHAR2(10 BYTE)               NOT NULL,

  DESC_CAS_057  VARCHAR2(250 BYTE)              NOT NULL,

  DESC_EUS_057  VARCHAR2(250 BYTE)              NOT NULL

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B57T00 IS 'Tabla historial de actas';



COMMENT ON COLUMN W83B57T00.N_ACTA_057 IS 'Nmero del acta';



COMMENT ON COLUMN W83B57T00.ANO_ACTA_057 IS 'Ao del acta';



COMMENT ON COLUMN W83B57T00.C_TERRIT_057 IS 'Territorio del acta';



COMMENT ON COLUMN W83B57T00.FACTU_057 IS 'Fecha de actualizacin';



COMMENT ON COLUMN W83B57T00.USUA_057 IS 'usuario de actualizacin';



COMMENT ON COLUMN W83B57T00.DESC_CAS_057 IS 'Descripcin de la accin en castellano';



COMMENT ON COLUMN W83B57T00.DESC_EUS_057 IS 'Descripcin de la accin en euskera';





CREATE OR REPLACE SYNONYM W83B57S00 FOR W83B57T00;



/* **************************************************************************************************** */



CREATE TABLE W83B58T00

(

  N_ACTA_058     NUMBER(6)                      NOT NULL,

  ANO_ACTA_058   NUMBER(4)                      NOT NULL,

  C_TERRIT_058   VARCHAR2(2 BYTE)               NOT NULL,

  VERSION_058    NUMBER(2)                      NOT NULL,

  C_TRAM_058     NUMBER(4)                      NOT NULL,

  C_FASE_058     NUMBER(4)                      NOT NULL,

  F_ACTU_058     DATE                           NOT NULL,

  USUA_058       VARCHAR2(10 BYTE)              NOT NULL,

  F_REG_SAL_058  DATE,

  N_REG_SAL_058  VARCHAR2(15 BYTE),

  F_NOTIF_058    DATE,

  F_EXPIR_058    DATE,

  F_MODIF_058    DATE,

  USU_MOD_058    VARCHAR2(10 BYTE),

  F_TRAM_058     DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B58T00 IS 'Tabla de historial tramitacin acta';



COMMENT ON COLUMN W83B58T00.F_MODIF_058 IS 'Fecha de modificacin';



COMMENT ON COLUMN W83B58T00.USU_MOD_058 IS 'Usuario de modificacin';



COMMENT ON COLUMN W83B58T00.N_ACTA_058 IS 'Nmero del acta';



COMMENT ON COLUMN W83B58T00.ANO_ACTA_058 IS 'Ao del acta';



COMMENT ON COLUMN W83B58T00.C_TERRIT_058 IS 'Territorio del acta';



COMMENT ON COLUMN W83B58T00.C_TRAM_058 IS 'Trmite del acta';



COMMENT ON COLUMN W83B58T00.C_FASE_058 IS 'Fase del acta';



COMMENT ON COLUMN W83B58T00.F_ACTU_058 IS 'Fecha en la que el acta apsa por esa fase/trmite';



COMMENT ON COLUMN W83B58T00.USUA_058 IS 'Usuario';



COMMENT ON COLUMN W83B58T00.F_REG_SAL_058 IS 'Fecha del registro de salida';



COMMENT ON COLUMN W83B58T00.N_REG_SAL_058 IS 'Nmero del registro de salida';



COMMENT ON COLUMN W83B58T00.F_NOTIF_058 IS 'Fecha de notificacin';



COMMENT ON COLUMN W83B58T00.F_EXPIR_058 IS 'Fechad e expiracin';





CREATE OR REPLACE SYNONYM W83B58S00 FOR W83B58T00;





ALTER TABLE W83B58T00 ADD (

  CONSTRAINT PK_W83B58T00 PRIMARY KEY (N_ACTA_058, ANO_ACTA_058, VERSION_058, C_TERRIT_058, C_TRAM_058, C_FASE_058, F_ACTU_058)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B59T00

(

  ANO_IMPUGN_059    NUMBER(4)                   NOT NULL,

  NUM_IMPUGNAC_059  NUMBER(6)                   NOT NULL,

  C_TERRIT_059      VARCHAR2(2 BYTE)            NOT NULL,

  ID_CENTRO_059     NUMBER(6),

  HORADESDE_059     DATE                        NOT NULL,

  DNI_IMPUGN_059    VARCHAR2(9 BYTE),

  NOMBRE_IMP_059    VARCHAR2(100 BYTE),

  DIR_IMP_059       VARCHAR2(100 BYTE),

  MUNIC_IMP_059     VARCHAR2(3 BYTE),

  PROV_IMPUG_059    VARCHAR2(2 BYTE),

  MESA_059          VARCHAR2(1 BYTE),

  DIR_MESA_059      VARCHAR2(100 BYTE),

  MUNIC_MESA_059    VARCHAR2(2 BYTE),

  PROV_MESA_059     VARCHAR2(2 BYTE),

  HORAHASTA_059     DATE                        NOT NULL,

  DIR_ORIG_059      VARCHAR2(1 BYTE),

  CODPOS_IMP_059    VARCHAR2(5 BYTE),

  ORD_SIND_059		VARCHAR2(200 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B59T00 IS 'Tabla de citaciones';



COMMENT ON COLUMN W83B59T00.DIR_IMP_059 IS 'Direccin del impugnante';



COMMENT ON COLUMN W83B59T00.MUNIC_IMP_059 IS 'Municipio del impugnante';



COMMENT ON COLUMN W83B59T00.PROV_IMPUG_059 IS 'Provincia del impugnante';



COMMENT ON COLUMN W83B59T00.MESA_059 IS 'Indica si notificar o no a la mesa electoral. 0: No, 1: S';



COMMENT ON COLUMN W83B59T00.DIR_MESA_059 IS 'Direccin de la mesa electoral';



COMMENT ON COLUMN W83B59T00.MUNIC_MESA_059 IS 'Municipio de la mesa electoral';



COMMENT ON COLUMN W83B59T00.PROV_MESA_059 IS 'Provincia de la mesa electoral';



COMMENT ON COLUMN W83B59T00.HORAHASTA_059 IS 'Hora hasta de la cita';



COMMENT ON COLUMN W83B59T00.NOMBRE_IMP_059 IS 'Nombre del impugnante';



COMMENT ON COLUMN W83B59T00.ANO_IMPUGN_059 IS 'Ao de la impugnacin';



COMMENT ON COLUMN W83B59T00.NUM_IMPUGNAC_059 IS 'Nmero deimpugnacin';



COMMENT ON COLUMN W83B59T00.C_TERRIT_059 IS 'Territorio de la impugnacin';



COMMENT ON COLUMN W83B59T00.ID_CENTRO_059 IS 'Centro de trabajo';



COMMENT ON COLUMN W83B59T00.HORADESDE_059 IS 'Hora desde de la cita';



COMMENT ON COLUMN W83B59T00.DNI_IMPUGN_059 IS 'DNI impugnante';



COMMENT ON COLUMN W83B59T00.DIR_ORIG_059 IS 'Indica si la direccion es la original del preaviso. 0:No, 1:S';



COMMENT ON COLUMN W83B59T00. CODPOS_IMP_059 IS 'Codigo Postal del impugnante';



COMMENT ON COLUMN W83B59T00. ORD_SIND_059 IS 'Orden de ingreso de sindicatos';





CREATE UNIQUE INDEX PK_W83B59T00 ON W83B59T00

(ANO_IMPUGN_059, NUM_IMPUGNAC_059, C_TERRIT_059)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





CREATE OR REPLACE SYNONYM W83B59S00 FOR W83B59T00;





ALTER TABLE W83B59T00 ADD (

  CONSTRAINT PK_W83B59T00 PRIMARY KEY (ANO_IMPUGN_059, NUM_IMPUGNAC_059, C_TERRIT_059)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B60T00

(

  NUM_IMPUGNAC_060  NUMBER(6)                   NOT NULL,

  ANO_IMPUGN_060    NUMBER(4)                   NOT NULL,

  C_TERRIT_060      VARCHAR2(2 BYTE)            NOT NULL,

  C_SINDI_060       NUMBER(3)                   NOT NULL,

  DIR_SINDI_060     VARCHAR2(150 BYTE),

  PROV_SINDI_060    VARCHAR2(2 BYTE),

  MUN_SINDI_060     VARCHAR2(3 BYTE),

  TIPO_SINDI_060    VARCHAR2(1 BYTE),

  CODPOS_060        VARCHAR2(5 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B60T00 IS 'Tabla de sindicatos por citacin';



COMMENT ON COLUMN W83B60T00.DIR_SINDI_060 IS 'Direccin del sindicato';



COMMENT ON COLUMN W83B60T00.PROV_SINDI_060 IS 'Provincia del sindicato';



COMMENT ON COLUMN W83B60T00.MUN_SINDI_060 IS 'Municipio del sindicato';



COMMENT ON COLUMN W83B60T00.TIPO_SINDI_060 IS 'Tipo de sindicato';



COMMENT ON COLUMN W83B60T00.CODPOS_060 IS 'Cdigo postal';



COMMENT ON COLUMN W83B60T00.NUM_IMPUGNAC_060 IS 'Nmero de la  impugnacin';



COMMENT ON COLUMN W83B60T00.ANO_IMPUGN_060 IS 'Ao de la  impugnacin';



COMMENT ON COLUMN W83B60T00.C_TERRIT_060 IS 'Territorio de la impugnacin';



COMMENT ON COLUMN W83B60T00.C_SINDI_060 IS 'Cdigo del sindicato';





CREATE OR REPLACE SYNONYM W83B60S00 FOR W83B60T00;



/* **************************************************************************************************** */



CREATE TABLE W83B61T00

(

  N_INCID_061        NUMBER(6)                  NOT NULL,

  ANO_INCID_061      NUMBER(4)                  NOT NULL,

  C_TERRIT_061       VARCHAR2(2 BYTE)           NOT NULL,

  TP_INCIDENCIA_061  VARCHAR2(2 BYTE)           NOT NULL,

  TP_SOLICIT_061     NUMBER,

  N_ACTA_061         NUMBER(6)                  NOT NULL,

  ANO_ACTA_061       NUMBER(4)                  NOT NULL,

  VERSION_ACTA_061   NUMBER(4)                  NOT NULL,

  VALIDADA_061       VARCHAR2(1 BYTE),

  F_ENTRADA_061      DATE,

  N_REG_ENT_061      VARCHAR2(15 BYTE),

  DNI_SOLIC_061      VARCHAR2(9 BYTE),

  RZ_SOCIAL_061      VARCHAR2(100 BYTE),

  OBSERVACIONES_061  VARCHAR2(500 BYTE),

  F_VALIDAC_061      DATE,

  F_REGISTRO_061      DATE,

  N_ACTA_PARCIAL_061         NUMBER(6)                  NOT NULL,

  ANO_ACTA_PARCIAL_061       NUMBER(4)                  NOT NULL

  

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B61T00 IS 'Tabla de Indicencias';



COMMENT ON COLUMN W83B61T00.F_VALIDAC_061 IS 'Fecha de validacin de la incidencia';



COMMENT ON COLUMN W83B61T00.N_INCID_061 IS 'Nmero de indicencia';



COMMENT ON COLUMN W83B61T00.ANO_INCID_061 IS 'Ao de indicencia';



COMMENT ON COLUMN W83B61T00.C_TERRIT_061 IS 'Territorio de indicencia';



COMMENT ON COLUMN W83B61T00.TP_INCIDENCIA_061 IS 'Tipo de incidencia';



COMMENT ON COLUMN W83B61T00.TP_SOLICIT_061 IS 'Tipo de solicitante';



COMMENT ON COLUMN W83B61T00.N_ACTA_061 IS 'Nmero de acta';



COMMENT ON COLUMN W83B61T00.ANO_ACTA_061 IS 'Ao del acta';



COMMENT ON COLUMN W83B61T00.VERSION_ACTA_061 IS 'Versin del acta';



COMMENT ON COLUMN W83B61T00.VALIDADA_061 IS 'Validada, 1:Si, 0:No';



COMMENT ON COLUMN W83B61T00.F_ENTRADA_061 IS 'Fecha de entrada';



COMMENT ON COLUMN W83B61T00.F_REGISTRO_061 IS 'Fecha de registro';



COMMENT ON COLUMN W83B61T00.N_REG_ENT_061 IS 'Nmero de registro de entrada';



COMMENT ON COLUMN W83B61T00.DNI_SOLIC_061 IS 'Dni solicitante';



COMMENT ON COLUMN W83B61T00.RZ_SOCIAL_061 IS 'Razn social';



COMMENT ON COLUMN W83B61T00.OBSERVACIONES_061 IS 'Observaciones';



COMMENT ON COLUMN W83B61T00.N_ACTA_PARCIAL_061 IS 'Nmero de acta parcial';



COMMENT ON COLUMN W83B61T00.ANO_ACTA_PARCIAL_061 IS 'Ao de acta parcial';





CREATE UNIQUE INDEX PK_W83B61T00 ON W83B61T00

(N_INCID_061, ANO_INCID_061, C_TERRIT_061)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





CREATE OR REPLACE SYNONYM W83B61S00 FOR W83B61T00;





ALTER TABLE W83B61T00 ADD (

  CONSTRAINT PK_W83B61T00 PRIMARY KEY (N_INCID_061, ANO_INCID_061, C_TERRIT_061)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B62T00

(

  TP_INCIDENCIA_062  VARCHAR2(2 BYTE)           NOT NULL,

  DESC_INCID_062     VARCHAR2(250 BYTE)         NOT NULL,

  DESE_INCID_062     VARCHAR2(250 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B62T00 IS 'Tbala de tipos de incidencias';



COMMENT ON COLUMN W83B62T00.TP_INCIDENCIA_062 IS 'Tipo de incidencia';



COMMENT ON COLUMN W83B62T00.DESC_INCID_062 IS 'Descripcin castellano de la incidencia';



COMMENT ON COLUMN W83B62T00.DESE_INCID_062 IS 'Descripcin euskera de la incidencia';





CREATE UNIQUE INDEX PK_W83B62T00 ON W83B62T00

(TP_INCIDENCIA_062)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





CREATE OR REPLACE SYNONYM W83B62S00 FOR W83B62T00;





ALTER TABLE W83B62T00 ADD (

  CONSTRAINT PK_W83B62T00 PRIMARY KEY (TP_INCIDENCIA_062)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B63T00

(

  TP_SOLICIT_063  NUMBER(2)                     NOT NULL,

  DESC_SOLIC_063  VARCHAR2(250 BYTE)            NOT NULL,

  DESE_SOLIC_063  VARCHAR2(250 BYTE)            NOT NULL

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B63T00 IS 'Tabla de tipos de solicitantes';



COMMENT ON COLUMN W83B63T00.TP_SOLICIT_063 IS 'Tipo de solicitante';



COMMENT ON COLUMN W83B63T00.DESC_SOLIC_063 IS 'Descripcin castellano del solicitante';



COMMENT ON COLUMN W83B63T00.DESE_SOLIC_063 IS 'Descripcin eurskera del solicitante';





CREATE UNIQUE INDEX PK_W83B63T00 ON W83B63T00

(TP_SOLICIT_063)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





CREATE OR REPLACE SYNONYM W83B63S00 FOR W83B63T00;





ALTER TABLE W83B63T00 ADD (

  CONSTRAINT PK_W83B63T00 PRIMARY KEY (TP_SOLICIT_063)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B64T00

(

  ID_DOC_064        NUMBER(7)                   NOT NULL,

  N_INCID_064       NUMBER(6)                   NOT NULL,

  ANO_INCID_064     NUMBER(4)                   NOT NULL,

  C_TERRIT_064      VARCHAR2(2 BYTE)            NOT NULL,

  C_TRAM_064        NUMBER(4)                   NOT NULL,

  C_FASE_064        NUMBER(4)                   NOT NULL,

  VERSION_ACTA_064  NUMBER(4),

  NOMB_DOCU_064     VARCHAR2(100 BYTE),

  LONG_DOCU_064     NUMBER(10),

  FICHERO_064       BLOB,

  TP_DOC_064        NUMBER(3),

  NUM_REG_064       VARCHAR2(15 BYTE),

  F_REG_064         DATE,

  USUARIO_064       VARCHAR2(100 BYTE),

  F_ACTU_064        DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

LOB (FICHERO_064) STORE AS 

      ( TABLESPACE  W8301E00 

        DISABLE     STORAGE IN ROW

        CHUNK       8192

        PCTVERSION  0

        NOCACHE

        STORAGE    (

                    INITIAL          64K

                    NEXT             128K

                    MINEXTENTS       1

                    MAXEXTENTS       2147483645

                    PCTINCREASE      0

                    BUFFER_POOL      DEFAULT

                   )

      )

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B64T00 IS 'Tabla de docs. adjuntos a la incidencia';



COMMENT ON COLUMN W83B64T00.N_INCID_064 IS 'Nmero de incidencia';



COMMENT ON COLUMN W83B64T00.ANO_INCID_064 IS 'Ao de incidencia';



COMMENT ON COLUMN W83B64T00.C_TERRIT_064 IS 'Territorio';



COMMENT ON COLUMN W83B64T00.VERSION_ACTA_064 IS 'Versin del acta';



COMMENT ON COLUMN W83B64T00.FICHERO_064 IS 'Fichero';



COMMENT ON COLUMN W83B64T00.TP_DOC_064 IS 'Tipo documento';



COMMENT ON COLUMN W83B64T00.NUM_REG_064 IS 'Nmero de registro';



COMMENT ON COLUMN W83B64T00.F_REG_064 IS 'Fecha de registro';



COMMENT ON COLUMN W83B64T00.USUARIO_064 IS 'Usuario';





CREATE UNIQUE INDEX PK_W83B64T00 ON W83B64T00

(ID_DOC_064, N_INCID_064, ANO_INCID_064, C_TERRIT_064)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





CREATE OR REPLACE SYNONYM W83B64S00 FOR W83B64T00;





ALTER TABLE W83B64T00 ADD (

  CONSTRAINT PK_W83B64T00 PRIMARY KEY (ID_DOC_064, N_INCID_064, ANO_INCID_064, C_TERRIT_064)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B65T00

(

  COD_CAMPO_065   NUMBER(3)                     NOT NULL,

  NOM_CAMPOC_065   VARCHAR2(50 BYTE)             NOT NULL,

  NOM_CAMPOE_065   VARCHAR2(50 BYTE)             NOT NULL,

  NOM_TABLA_065   VARCHAR2(50 BYTE)             NOT NULL,

  DESC_CAMPO_065  VARCHAR2(250 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B65T00 IS 'Tabla de campos de actas';



COMMENT ON COLUMN W83B65T00.COD_CAMPO_065 IS 'Cdigo del campo';



COMMENT ON COLUMN W83B65T00.NOM_CAMPOC_065 IS 'Nombre en BD del campo castellano';



COMMENT ON COLUMN W83B65T00.NOM_CAMPOE_065 IS 'Nombre en BD del campo euskera';



COMMENT ON COLUMN W83B65T00.NOM_TABLA_065 IS 'Nombre de la tabla en BD';



COMMENT ON COLUMN W83B65T00.DESC_CAMPO_065 IS 'Descripcin del campo';





CREATE UNIQUE INDEX PK_W83B65T00 ON W83B65T00

(COD_CAMPO_065)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





CREATE OR REPLACE SYNONYM W83B65S00 FOR W83B65T00;





ALTER TABLE W83B65T00 ADD (

  CONSTRAINT PK_W83B65T00 PRIMARY KEY (COD_CAMPO_065)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B66T00

(

  ID_066			NUMBER(7)                   NOT NULL,

  N_INCID_066       NUMBER(6)                   NOT NULL,

  ANO_INCID_066     NUMBER(4)                   NOT NULL,

  C_TERRIT_066      VARCHAR2(2 BYTE)            NOT NULL,

  COD_CAMPO_066     NUMBER(3)                   NOT NULL,

  VALOR_ANT_066     VARCHAR2(150 BYTE),

  VALOR_ACTUAL_066  VARCHAR2(150 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B66T00 IS 'Subsanaciones';



COMMENT ON COLUMN W83B66T00.N_INCID_066 IS 'Nmero de la incidencia';



COMMENT ON COLUMN W83B66T00.ANO_INCID_066 IS 'Ao de la incidencia';



COMMENT ON COLUMN W83B66T00.C_TERRIT_066 IS 'Territorio';



COMMENT ON COLUMN W83B66T00.COD_CAMPO_066 IS 'Cdigo del campo';



COMMENT ON COLUMN W83B66T00.VALOR_ANT_066 IS 'Valor anterior';



COMMENT ON COLUMN W83B66T00.VALOR_ACTUAL_066 IS 'Valor actual';





CREATE UNIQUE INDEX PK_W83B66T00 ON W83B66T00

(ID_066)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





CREATE OR REPLACE SYNONYM W83B66S00 FOR W83B66T00;





ALTER TABLE W83B66T00 ADD (

  CONSTRAINT PK_W83B66T00 PRIMARY KEY (ID_066)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B67T00

(

  ID_067			 NUMBER(7)                   NOT NULL,

  N_INCID_067        NUMBER(6)                  NOT NULL,

  ANO_INCID_067      NUMBER(4)                  NOT NULL,

  C_TERRIT_067       VARCHAR2(2 BYTE)           NOT NULL,

  DNI_SUTITUIDO_067  VARCHAR2(10 BYTE),

  DNI_SUSTITUTO_067  VARCHAR2(10 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B67T00 IS 'Tablas de incidencias de tipo sustitucin';



COMMENT ON COLUMN W83B67T00.N_INCID_067 IS 'Nmero de la incidencia';



COMMENT ON COLUMN W83B67T00.ANO_INCID_067 IS 'Ao de la incidencia';



COMMENT ON COLUMN W83B67T00.C_TERRIT_067 IS 'Territorio';



COMMENT ON COLUMN W83B67T00.DNI_SUTITUIDO_067 IS 'Dni sustituido';



COMMENT ON COLUMN W83B67T00.DNI_SUSTITUTO_067 IS 'Dni sustituto';





CREATE UNIQUE INDEX PK_W83B67T00 ON W83B67T00

(ID_067)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





CREATE OR REPLACE SYNONYM W83B67S00 FOR W83B67T00;





ALTER TABLE W83B67T00 ADD (

  CONSTRAINT PK_W83B67T00 PRIMARY KEY (ID_067)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B68T00

(

  N_LAUDO_068    NUMBER(3),

  ANO_LAUDO_068  NUMBER(4),

  C_TERRIT_068   VARCHAR2(2 BYTE),

  ANO_IMPUG_068  NUMBER(4)                      NOT NULL,

  N_IMPUG_068    NUMBER(6)                      NOT NULL,

  FLAUDO_068     DATE,

  RDO_LAUDO_068  NUMBER(1)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B68T00 IS 'Tabla de laudos';



COMMENT ON COLUMN W83B68T00.N_LAUDO_068 IS 'Nmero de laudo';



COMMENT ON COLUMN W83B68T00.ANO_LAUDO_068 IS 'Ao del laudo';



COMMENT ON COLUMN W83B68T00.C_TERRIT_068 IS 'Territorio';



COMMENT ON COLUMN W83B68T00.ANO_IMPUG_068 IS 'Ao de la impugnacin';



COMMENT ON COLUMN W83B68T00.N_IMPUG_068 IS 'Nmero de la impugnacin';



COMMENT ON COLUMN W83B68T00.FLAUDO_068 IS 'Fecha del laudo';



COMMENT ON COLUMN W83B68T00.RDO_LAUDO_068 IS 'Resultado del laudo';





CREATE OR REPLACE SYNONYM W83B68S00 FOR W83B68T00;





ALTER TABLE W83B68T00 ADD (

  CONSTRAINT PK_W83B68T00 PRIMARY KEY (N_LAUDO_068, ANO_LAUDO_068, C_TERRIT_068, ANO_IMPUG_068, N_IMPUG_068)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B69T00

(

  IDTP_DOC_069  NUMBER(3)                       NOT NULL,

  C_TRAM_069    NUMBER(4)                       NOT NULL,

  C_FASE_069    NUMBER(4)                       NOT NULL,

  DESC_CAS_069  VARCHAR2(250 BYTE),

  DESC_EUS_069  VARCHAR2(250 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B69T00 IS 'Tabla de tipos de documentos tramitacin';



COMMENT ON COLUMN W83B69T00.IDTP_DOC_069 IS 'Tipo de documento';



COMMENT ON COLUMN W83B69T00.C_TRAM_069 IS 'Trmite al que pertenece el documento';



COMMENT ON COLUMN W83B69T00.C_FASE_069 IS 'Fase al que pertenece el documento';



COMMENT ON COLUMN W83B69T00.DESC_CAS_069 IS 'Descripcin castellano';



COMMENT ON COLUMN W83B69T00.DESC_EUS_069 IS 'Descripcin en euskera';





CREATE OR REPLACE SYNONYM W83B69S00 FOR W83B69T00;





ALTER TABLE W83B69T00 ADD (

  CONSTRAINT PK_W83B69T00 PRIMARY KEY (IDTP_DOC_069, C_TRAM_069, C_FASE_069)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B70T00

(

  ID_PLANT_070   NUMBER(3)                      NOT NULL,

  C_TRAM_070     NUMBER(4)                      NOT NULL,

  C_FASE_070     NUMBER(4)                      NOT NULL,

  PLANTILLA_070  BLOB,

  DESC_CAS_070   VARCHAR2(250 BYTE),

  DESC_EUS_070   VARCHAR2(250 BYTE),

  NOM_PLANT_070  VARCHAR2(50 BYTE)              NOT NULL

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

LOB (PLANTILLA_070) STORE AS W83B70SL00

      ( TABLESPACE  W8301E00 

        DISABLE     STORAGE IN ROW

        CHUNK       8192

        PCTVERSION  0

        NOCACHE

        STORAGE    (

                    INITIAL          128K

                    NEXT             128K

                    MINEXTENTS       1

                    MAXEXTENTS       2147483645

                    PCTINCREASE      0

                    BUFFER_POOL      DEFAULT

                   )

      )

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B70T00 IS 'Tabla de plantillas tramitacin';



COMMENT ON COLUMN W83B70T00.NOM_PLANT_070 IS 'Nombre de la plantilla';



COMMENT ON COLUMN W83B70T00.ID_PLANT_070 IS 'Id de la plantilla';



COMMENT ON COLUMN W83B70T00.C_TRAM_070 IS 'Trmite al que pertenece el documento';



COMMENT ON COLUMN W83B70T00.C_FASE_070 IS 'Fase a la que pertenece el documento';



COMMENT ON COLUMN W83B70T00.PLANTILLA_070 IS 'Plantilla';



COMMENT ON COLUMN W83B70T00.DESC_CAS_070 IS 'Descripcin castellano';



COMMENT ON COLUMN W83B70T00.DESC_EUS_070 IS 'Descripcin euskera';





CREATE OR REPLACE SYNONYM W83B70S00 FOR W83B70T00;





ALTER TABLE W83B70T00 ADD (

  CONSTRAINT PK_W83B70T00 PRIMARY KEY (ID_PLANT_070, C_TRAM_070, C_FASE_070)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B71T00

(

  ANO_IMPUG_071  NUMBER(4)                      NOT NULL,

  N_IMPUG_071    NUMBER(6)                      NOT NULL,

  C_TERRIT_071   VARCHAR2(2 BYTE)               NOT NULL,

  C_TRAM_071     NUMBER(4)                      NOT NULL,

  C_FASE_071     NUMBER(4)                      NOT NULL,

  F_ACTU_071     DATE                           NOT NULL,

  USUA_071       VARCHAR2(10 BYTE)              NOT NULL,

  F_REG_SAL_071  DATE,

  N_REG_SAL_071  VARCHAR2(15 BYTE),

  F_NOTIF_071    DATE,

  F_EXPIR_071    DATE,

  F_MODIF_071    DATE,

  USU_MOD_071    VARCHAR2(10 BYTE),

  F_TRAM_071     DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B71T00 IS 'Tabla de historial tramitacin impugnaciones';



COMMENT ON COLUMN W83B71T00.F_MODIF_071 IS 'Fecha de modificacin';



COMMENT ON COLUMN W83B71T00.USU_MOD_071 IS 'Usuario de modificacin';



COMMENT ON COLUMN W83B71T00.ANO_IMPUG_071 IS 'Nmero de la impugnacin';



COMMENT ON COLUMN W83B71T00.N_IMPUG_071 IS 'Ao de la impugnacin';



COMMENT ON COLUMN W83B71T00.C_TERRIT_071 IS 'Territorio de la impugnacin';



COMMENT ON COLUMN W83B71T00.C_TRAM_071 IS 'Trmite de la impugnacin';



COMMENT ON COLUMN W83B71T00.C_FASE_071 IS 'Fase de la impugnacin';



COMMENT ON COLUMN W83B71T00.F_ACTU_071 IS 'Fecha en la que la impugnacin pasa por esa fase/trmite';



COMMENT ON COLUMN W83B71T00.USUA_071 IS 'Usuario';



COMMENT ON COLUMN W83B71T00.F_REG_SAL_071 IS 'Fecha del registro de salida';



COMMENT ON COLUMN W83B71T00.N_REG_SAL_071 IS 'Nmero del registro de salida';



COMMENT ON COLUMN W83B71T00.F_NOTIF_071 IS 'Fecha de notificacin';



COMMENT ON COLUMN W83B71T00.F_EXPIR_071 IS 'Fechad e expiracin';





CREATE OR REPLACE SYNONYM W83B71S00 FOR W83B71T00;





ALTER TABLE W83B71T00 ADD (

  CONSTRAINT PK_W83B71T00 PRIMARY KEY (N_IMPUG_071, ANO_IMPUG_071, C_TERRIT_071, C_TRAM_071, C_FASE_071, F_ACTU_071)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B72T00

(

  ANO_INCID_072  NUMBER(4)                      NOT NULL,

  N_INCID_072    NUMBER(6)                      NOT NULL,

  C_TERRIT_072   VARCHAR2(2 BYTE)               NOT NULL,

  C_TRAM_072     NUMBER(4)                      NOT NULL,

  C_FASE_072     NUMBER(4)                      NOT NULL,

  F_ACTU_072     DATE                           NOT NULL,

  USUA_072       VARCHAR2(10 BYTE)              NOT NULL,

  F_REG_SAL_072  DATE,

  N_REG_SAL_072  VARCHAR2(15 BYTE),

  F_NOTIF_072    DATE,

  F_EXPIR_072    DATE,

  F_MODIF_072    DATE,

  USU_MOD_072    VARCHAR2(10 BYTE),

  F_TRAM_072     DATE

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B72T00 IS 'Tabla de historial tramitacin incidencias';



COMMENT ON COLUMN W83B72T00.F_MODIF_072 IS 'Fecha de modificacin';



COMMENT ON COLUMN W83B72T00.USU_MOD_072 IS 'Usuario de modificacin';



COMMENT ON COLUMN W83B72T00.ANO_INCID_072 IS 'Ao de la incidencia';



COMMENT ON COLUMN W83B72T00.N_INCID_072 IS 'Nmero de la incidencia';



COMMENT ON COLUMN W83B72T00.C_TERRIT_072 IS 'Territorio de la incidencia';



COMMENT ON COLUMN W83B72T00.C_TRAM_072 IS 'Trmite de la incidencia';



COMMENT ON COLUMN W83B72T00.C_FASE_072 IS 'Fase de la incidencia';



COMMENT ON COLUMN W83B72T00.F_ACTU_072 IS 'Fecha en la que la incidencia pasa por esa fase/trmite';



COMMENT ON COLUMN W83B72T00.USUA_072 IS 'Usuario';



COMMENT ON COLUMN W83B72T00.F_REG_SAL_072 IS 'Fecha del registro de salida';



COMMENT ON COLUMN W83B72T00.N_REG_SAL_072 IS 'Nmero del registro de salida';



COMMENT ON COLUMN W83B72T00.F_NOTIF_072 IS 'Fecha de notificacin';



COMMENT ON COLUMN W83B72T00.F_EXPIR_072 IS 'Fechad e expiracin';





CREATE OR REPLACE SYNONYM W83B72S00 FOR W83B72T00;





ALTER TABLE W83B72T00 ADD (

  CONSTRAINT PK_W83B72T00 PRIMARY KEY (N_INCID_072, ANO_INCID_072, C_TERRIT_072, C_TRAM_072, C_FASE_072, F_ACTU_072)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B73T00

(

  N_IMPUG_073    NUMBER(6),

  ANO_IMPUG_073  NUMBER(4),

  C_TERRIT_073   VARCHAR2(2 BYTE),

  FACTU_073      DATE,

  USUA_073       VARCHAR2(15 BYTE),

  DESC_CAS_073   VARCHAR2(250 BYTE),

  DESC_EUS_073   VARCHAR2(250 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B73T00 IS 'Tabla de auditoria de impugnaciones y laudos';



COMMENT ON COLUMN W83B73T00.N_IMPUG_073 IS 'Nmero de la impugnacin';



COMMENT ON COLUMN W83B73T00.ANO_IMPUG_073 IS 'Ao de la impugnacin';



COMMENT ON COLUMN W83B73T00.C_TERRIT_073 IS 'Territorio de la impugnacin';



COMMENT ON COLUMN W83B73T00.FACTU_073 IS 'Fecha de actualizacin';



COMMENT ON COLUMN W83B73T00.USUA_073 IS 'Usuario de actualizacin';



COMMENT ON COLUMN W83B73T00.DESC_CAS_073 IS 'Descripcin de la accin en castellano';



COMMENT ON COLUMN W83B73T00.DESC_EUS_073 IS 'Descripcin de la accin en euskera';





CREATE OR REPLACE SYNONYM W83B73S00 FOR W83B73T00;



/* **************************************************************************************************** */



CREATE TABLE W83B74T00

(

  N_INCID_074    NUMBER(6),

  ANO_INCID_074  NUMBER(4),

  C_TERRIT_074   VARCHAR2(2 BYTE),

  FACTU_074      DATE,

  USUA_074       VARCHAR2(15 BYTE),

  DESC_CAS_074   VARCHAR2(250 BYTE),

  DESC_EUS_074   VARCHAR2(250 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B74T00 IS 'Tabla de auditoria de incidencias';



COMMENT ON COLUMN W83B74T00.N_INCID_074 IS 'Nmero de la incidencia';



COMMENT ON COLUMN W83B74T00.ANO_INCID_074 IS 'Ao de la incidencia';



COMMENT ON COLUMN W83B74T00.C_TERRIT_074 IS 'Territorio de la incidenca';



COMMENT ON COLUMN W83B74T00.FACTU_074 IS 'Fecha de actualizacin';



COMMENT ON COLUMN W83B74T00.USUA_074 IS 'Usuario de actualizacin';



COMMENT ON COLUMN W83B74T00.DESC_CAS_074 IS 'Descripcin de la accin en castellano';



COMMENT ON COLUMN W83B74T00.DESC_EUS_074 IS 'Descripcin de la accin en euskera';





CREATE OR REPLACE SYNONYM W83B74S00 FOR W83B74T00;



/* **************************************************************************************************** */



CREATE TABLE W83B75T00

(

  ID_RDO_075        NUMBER(1)                   NOT NULL,

  DESC_RDO_CAS_075  VARCHAR2(250 BYTE)          NOT NULL,

  DESC_RDO_EUS_075  VARCHAR2(250 BYTE)          NOT NULL

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B75T00 IS 'Tabla de resultado de laudo';



COMMENT ON COLUMN W83B75T00.ID_RDO_075 IS 'Identificador del resultado';



COMMENT ON COLUMN W83B75T00.DESC_RDO_CAS_075 IS 'Descripcin del resultado en castellano';



COMMENT ON COLUMN W83B75T00.DESC_RDO_EUS_075 IS 'Descripcin del resultado en euskera';





CREATE OR REPLACE SYNONYM W83B75S00 FOR W83B75T00;





ALTER TABLE W83B75T00 ADD (

  CONSTRAINT PK_W83B75T00 PRIMARY KEY (ID_RDO_075)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B76T00

(

  ANO_IMPUG_076   NUMBER(4)                     NOT NULL,

  N_IMPUG_076     NUMBER(6)                     NOT NULL,

  C_TERRIT_076    VARCHAR2(2 BYTE)              NOT NULL,

  DNI_IMP_076     VARCHAR2(10 BYTE),

  NOMBRE_IMP_076  VARCHAR2(150 BYTE),

  DIR_IMP_076     VARCHAR2(150 BYTE),

  MUN_IMP_076     VARCHAR2(3 BYTE),

  PROV_IMP_076    VARCHAR2(2 BYTE),

  CODPOS_IMP_076  VARCHAR2(5 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          64K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B76T00 IS 'Tabla de resultado de laudo';



COMMENT ON COLUMN W83B76T00.CODPOS_IMP_076 IS 'Cdigo postal del impugnante';



COMMENT ON COLUMN W83B76T00.ANO_IMPUG_076 IS 'Ao de la impugnacin';



COMMENT ON COLUMN W83B76T00.N_IMPUG_076 IS 'Nmero de la impugnacin';



COMMENT ON COLUMN W83B76T00.C_TERRIT_076 IS 'Territorio de la impugnacin';



COMMENT ON COLUMN W83B76T00.DNI_IMP_076 IS 'DNI del impugnante';



COMMENT ON COLUMN W83B76T00.NOMBRE_IMP_076 IS 'Nombre del impugnante';



COMMENT ON COLUMN W83B76T00.DIR_IMP_076 IS 'Direccin del impugnante';



COMMENT ON COLUMN W83B76T00.MUN_IMP_076 IS 'Municipio del impugnante';



COMMENT ON COLUMN W83B76T00.PROV_IMP_076 IS 'Provincia del impugnante';





CREATE OR REPLACE SYNONYM W83B76S00 FOR W83B76T00;





ALTER TABLE W83B76T00 ADD (

  CONSTRAINT PK_W83B76T00 PRIMARY KEY (ANO_IMPUG_076, N_IMPUG_076, C_TERRIT_076)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          64K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B98T00

(

  ID_098           NUMBER(8)                    NOT NULL,

  TABLA_098        VARCHAR2(10 BYTE),

  DESCRIPCION_098  VARCHAR2(2000 BYTE)

)

TABLESPACE W8301E00

PCTUSED    0

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          128K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCOMPRESS 

NOCACHE

NOPARALLEL

MONITORING;



COMMENT ON TABLE W83B98T00 IS 'Tabla de trazas';



COMMENT ON COLUMN W83B98T00.ID_098 IS 'Id';



COMMENT ON COLUMN W83B98T00.TABLA_098 IS 'Tabla de la traza';



COMMENT ON COLUMN W83B98T00.DESCRIPCION_098 IS 'Descripcin de la inserccin, seleccin, etc';





CREATE UNIQUE INDEX PK_W83B98T00 ON W83B98T00

(ID_098)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          128K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





ALTER TABLE W83B98T00 ADD (

  CONSTRAINT PK_W83B98T00 PRIMARY KEY (ID_098)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          128K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

               ));

			   

/* ******************************************************************************* */	



CREATE TABLE W83B77T00

(

  C_TERRIT_077  NUMBER(2)                       NOT NULL,

  ANO_RES_077   NUMBER(4)                       NOT NULL,

  MES_RES_077   NUMBER(2)                       NOT NULL,

  C_CONV_077    VARCHAR2(3)                     NOT NULL,

  C_SINDI_077   VARCHAR2(3)                     NOT NULL,

  N_DEMH49_077  NUMBER(6),

  N_DEMM49_077  NUMBER(6),

  N_DELH_077    NUMBER(6),

  N_DELM_077    NUMBER(6)

)

TABLESPACE W8301E00

PCTUSED    40

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          240K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            FREELISTS        1

            FREELIST GROUPS  1

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCACHE

NOPARALLEL;



COMMENT ON TABLE W83B77T00 IS 'Tabla de Histrico Mensual Convenio-Sindicato';



COMMENT ON COLUMN W83B77T00.C_CONV_077 IS 'Cdigo de Convenio';



COMMENT ON COLUMN W83B77T00.C_SINDI_077 IS 'Cdigo de Sindicato';



COMMENT ON COLUMN W83B77T00.N_DEMH49_077 IS 'Delegados de Empresas de hasta 49 Trabajadores';



COMMENT ON COLUMN W83B77T00.N_DEMM49_077 IS 'Delegados de Empresas de ms 49 Trabajadores';



COMMENT ON COLUMN W83B77T00.N_DELH_077 IS 'Delegados Hombres';



COMMENT ON COLUMN W83B77T00.N_DELM_077 IS 'Delegados Mujeres';



COMMENT ON COLUMN W83B77T00.C_TERRIT_077 IS 'Territorio';



COMMENT ON COLUMN W83B77T00.ANO_RES_077 IS 'Ao';



COMMENT ON COLUMN W83B77T00.MES_RES_077 IS 'Ms';





CREATE UNIQUE INDEX PK_W83B77T00 ON W83B77T00

(C_TERRIT_077, ANO_RES_077, MES_RES_077, C_CONV_077, C_SINDI_077)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          240K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            FREELISTS        1

            FREELIST GROUPS  1

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





CREATE OR REPLACE SYNONYM W83B77S00 FOR W83B77T00;





ALTER TABLE W83B77T00 ADD (

  CONSTRAINT PK_W83B77T00 PRIMARY KEY (C_TERRIT_077, ANO_RES_077, MES_RES_077, C_CONV_077, C_SINDI_077)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          240K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

                FREELISTS        1

                FREELIST GROUPS  1

               ));



/* **************************************************************************************************** */		   



CREATE TABLE W83B78T00

(

  C_TERRIT_078    NUMBER(2)                     NOT NULL,

  ANO_RES_078     NUMBER(4)                     NOT NULL,

  MES_RES_078     NUMBER(2)                     NOT NULL,

  T_ELECHH49_078  NUMBER(9),

  T_ELECMH49_078  NUMBER(9),

  T_ELECNH49_078  NUMBER(9),

  T_ELECHM49_078  NUMBER(9),

  T_ELECMM49_078  NUMBER(9),

  T_ELECNM49_078  NUMBER(9),

  T_TRABH_078     NUMBER(9),

  T_TRABM_078     NUMBER(9),

  T_TRABN_078     NUMBER(9),

  T_CANDH_078     NUMBER(9),

  T_CANDM_078     NUMBER(9),

  T_CENTH49_078   NUMBER(6),

  T_VOTAH49_078   NUMBER(9),

  T_EMPRH49_078   NUMBER(6),

  T_CENTM49_078   NUMBER(6),

  T_VOTAM49_078   NUMBER(9),

  T_EMPRM49_078   NUMBER(6)

)

TABLESPACE W8301E00

PCTUSED    40

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          32K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            FREELISTS        1

            FREELIST GROUPS  1

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCACHE

NOPARALLEL;



COMMENT ON TABLE W83B78T00 IS 'Tabla de Histrico Mensual Convenio-Sindicato';



COMMENT ON COLUMN W83B78T00.C_TERRIT_078 IS 'Territorio';



COMMENT ON COLUMN W83B78T00.ANO_RES_078 IS 'Ao';



COMMENT ON COLUMN W83B78T00.MES_RES_078 IS 'Ms';



COMMENT ON COLUMN W83B78T00.T_ELECHH49_078 IS 'Total de Electores Hombres de Emp. hasta 49 trab.';



COMMENT ON COLUMN W83B78T00.T_ELECMH49_078 IS 'Total de Electores Mujeres de Emp. hasta 49 trab.';



COMMENT ON COLUMN W83B78T00.T_ELECNH49_078 IS 'Total de Electores No Consta de Emp. hasta 49 trab.';



COMMENT ON COLUMN W83B78T00.T_ELECHM49_078 IS 'Total de Electores Hombres de Emp. de ms de 49 trab.';



COMMENT ON COLUMN W83B78T00.T_ELECMM49_078 IS 'Total de Electores Mujeres de Emp. de ms de 49 trab.';



COMMENT ON COLUMN W83B78T00.T_ELECNM49_078 IS 'Total de Electores No Consta de Emp. de ms de 49 trab.';



COMMENT ON COLUMN W83B78T00.T_TRABH_078 IS 'Total de Trabajadores Hombres';



COMMENT ON COLUMN W83B78T00.T_TRABM_078 IS 'Total de Trabajadores Mujeres';



COMMENT ON COLUMN W83B78T00.T_TRABN_078 IS 'Total de Trabajadores No Consta';



COMMENT ON COLUMN W83B78T00.T_CANDH_078 IS 'Total de Candidatos Hombres';



COMMENT ON COLUMN W83B78T00.T_CANDM_078 IS 'Total de Candidatos Mujeres';



COMMENT ON COLUMN W83B78T00.T_CENTH49_078 IS 'Total de Centros de Emp. hasta 49 trab.';



COMMENT ON COLUMN W83B78T00.T_VOTAH49_078 IS 'Total de Votantes de Emp. hasta 49 trab.';



COMMENT ON COLUMN W83B78T00.T_EMPRH49_078 IS 'Total de Empresas de Emp. hasta 49 trab.';



COMMENT ON COLUMN W83B78T00.T_CENTM49_078 IS 'Total de Centros de Emp. de ms de 49 trab.';



COMMENT ON COLUMN W83B78T00.T_VOTAM49_078 IS 'Total de Votantes de Emp. de ms de 49 trab.';



COMMENT ON COLUMN W83B78T00.T_EMPRM49_078 IS 'Total de Empresas de Emp. de ms de 49 trab.';





CREATE UNIQUE INDEX PK_W83B78T00 ON W83B78T00

(C_TERRIT_078, ANO_RES_078, MES_RES_078)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          32K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            FREELISTS        1

            FREELIST GROUPS  1

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





CREATE OR REPLACE SYNONYM W83B78S00 FOR W83B78T00;





ALTER TABLE W83B78T00 ADD (

  CONSTRAINT PK_W83B78T00 PRIMARY KEY (C_TERRIT_078, ANO_RES_078, MES_RES_078)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          32K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

                FREELISTS        1

                FREELIST GROUPS  1

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B79T00

(

  C_TERRIT_079   NUMBER(2)                      NOT NULL,

  ANO_RES_079    NUMBER(4)                      NOT NULL,

  MES_RES_079    NUMBER(2)                      NOT NULL,

  C_SECTOR_079   VARCHAR2(2)                    NOT NULL,

  C_CONV_079     NUMBER(3)                      NOT NULL,

  T_CENTROS_079  NUMBER(6),

  T_TRABA_079    NUMBER(6),

  T_ELECT_079    NUMBER(6),

  T_VOTA_079     NUMBER(6)

)

TABLESPACE W8301E00

PCTUSED    40

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          128K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            FREELISTS        1

            FREELIST GROUPS  1

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCACHE

NOPARALLEL;



COMMENT ON TABLE W83B79T00 IS 'Tabla de Histrico Mensual Convenio-Sindicato';



COMMENT ON COLUMN W83B79T00.C_TERRIT_079 IS 'Territorio';



COMMENT ON COLUMN W83B79T00.ANO_RES_079 IS 'Ao';



COMMENT ON COLUMN W83B79T00.MES_RES_079 IS 'Ms';



COMMENT ON COLUMN W83B79T00.C_SECTOR_079 IS 'Cdigo de Sector';



COMMENT ON COLUMN W83B79T00.C_CONV_079 IS 'Cdigo de Convenio';



COMMENT ON COLUMN W83B79T00.T_CENTROS_079 IS 'Total de Centros';



COMMENT ON COLUMN W83B79T00.T_TRABA_079 IS 'Total de Trabajadores';



COMMENT ON COLUMN W83B79T00.T_ELECT_079 IS 'Total de Electores';



COMMENT ON COLUMN W83B79T00.T_VOTA_079 IS 'Total de Votantes';





CREATE UNIQUE INDEX PK_W83B79T00 ON W83B79T00

(C_TERRIT_079, ANO_RES_079, MES_RES_079, C_SECTOR_079, C_CONV_079)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          128K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            FREELISTS        1

            FREELIST GROUPS  1

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





CREATE OR REPLACE SYNONYM W83B79S00 FOR W83B79T00;





ALTER TABLE W83B79T00 ADD (

  CONSTRAINT PK_W83B79T00 PRIMARY KEY (C_TERRIT_079, ANO_RES_079, MES_RES_079, C_SECTOR_079, C_CONV_079)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          128K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

                FREELISTS        1

                FREELIST GROUPS  1

               ));



/* **************************************************************************************************** */



CREATE TABLE W83B80T00

(

  C_TERRIT_080  NUMBER(2)                       NOT NULL,

  ANO_RES_080   NUMBER(4)                       NOT NULL,

  MES_RES_080   NUMBER(2)                       NOT NULL,

  C_SECTOR_080  VARCHAR2(2)                     NOT NULL,

  C_CONV_080    NUMBER(3)                       NOT NULL,

  C_SINDI_080   NUMBER(3)                       NOT NULL,

  T_DELEG_080   NUMBER(6)

)

TABLESPACE W8301E00

PCTUSED    40

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          240K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            FREELISTS        1

            FREELIST GROUPS  1

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCACHE

NOPARALLEL;



COMMENT ON TABLE W83B80T00 IS 'Tabla de Histrico Mensual Convenio-Sindicato';



COMMENT ON COLUMN W83B80T00.C_TERRIT_080 IS 'Territorio';



COMMENT ON COLUMN W83B80T00.ANO_RES_080 IS 'Ao';



COMMENT ON COLUMN W83B80T00.MES_RES_080 IS 'Ms';



COMMENT ON COLUMN W83B80T00.C_SECTOR_080 IS 'Cdigo de Sector';



COMMENT ON COLUMN W83B80T00.C_CONV_080 IS 'Cdigo de Convenio';



COMMENT ON COLUMN W83B80T00.C_SINDI_080 IS 'Cdigo de Sindicato';



COMMENT ON COLUMN W83B80T00.T_DELEG_080 IS 'Total de Delegados';





CREATE UNIQUE INDEX PK_W83B80T00 ON W83B80T00

(C_TERRIT_080, ANO_RES_080, MES_RES_080, C_SECTOR_080, C_CONV_080, 

C_SINDI_080)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          320K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            FREELISTS        1

            FREELIST GROUPS  1

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





CREATE OR REPLACE SYNONYM W83B80S00 FOR W83B80T00;





ALTER TABLE W83B80T00 ADD (

  CONSTRAINT PK_W83B80T00 PRIMARY KEY (C_TERRIT_080, ANO_RES_080, MES_RES_080, C_SECTOR_080, C_CONV_080, C_SINDI_080)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          320K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

                FREELISTS        1

                FREELIST GROUPS  1

               ));

/* **************************************************************************************************** */



CREATE TABLE W83B81T00

(

  C_TERRIT_081       NUMBER(2)                  NOT NULL,

  ANO_RES_081        NUMBER(4)                  NOT NULL,

  MES_RES_081        NUMBER(2)                  NOT NULL,

  C_COMAR_081        NUMBER(2)                  NOT NULL,

  C_MUNI_081         NUMBER(4)                  NOT NULL,

  C_SINDI_081        NUMBER(3)                  NOT NULL,

  T_TRAB610_081      NUMBER(6),

  T_TRAB1130_081     NUMBER(6),

  T_TRAB3149_081     NUMBER(6),

  T_TRAB50100_081    NUMBER(6),

  T_TRAB101250_081   NUMBER(6),

  T_TRAB251500_081   NUMBER(6),

  T_TRAB501750_081   NUMBER(6),

  T_TRAB7511000_081  NUMBER(6),

  T_TRABM1000_081    NUMBER(6)

)

TABLESPACE W8301E00

PCTUSED    40

PCTFREE    10

INITRANS   1

MAXTRANS   255

STORAGE    (

            INITIAL          160K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            FREELISTS        1

            FREELIST GROUPS  1

            BUFFER_POOL      DEFAULT

           )

LOGGING 

NOCACHE

NOPARALLEL;



COMMENT ON TABLE W83B81T00 IS 'Tabla de Histrico Mensual Convenio-Sindicato';



COMMENT ON COLUMN W83B81T00.C_TERRIT_081 IS 'Territorio';



COMMENT ON COLUMN W83B81T00.ANO_RES_081 IS 'Ao';



COMMENT ON COLUMN W83B81T00.MES_RES_081 IS 'Ms';



COMMENT ON COLUMN W83B81T00.C_COMAR_081 IS 'Cdigo de Comarca';



COMMENT ON COLUMN W83B81T00.C_MUNI_081 IS 'Cdigo de Municipio';



COMMENT ON COLUMN W83B81T00.C_SINDI_081 IS 'Cdigo de Sindicato';



COMMENT ON COLUMN W83B81T00.T_TRAB610_081 IS 'Delegados en empresas de 6-10';



COMMENT ON COLUMN W83B81T00.T_TRAB1130_081 IS 'Delegados en empresas de 11-30';



COMMENT ON COLUMN W83B81T00.T_TRAB3149_081 IS 'Delegados en empresas de 31-49';



COMMENT ON COLUMN W83B81T00.T_TRAB50100_081 IS 'Delegados en empresas de 50-100';



COMMENT ON COLUMN W83B81T00.T_TRAB101250_081 IS 'Delegados en empresas de 101-250';



COMMENT ON COLUMN W83B81T00.T_TRAB251500_081 IS 'Delegados en empresas de 251-500';



COMMENT ON COLUMN W83B81T00.T_TRAB501750_081 IS 'Delegados en empresas de 501-750';



COMMENT ON COLUMN W83B81T00.T_TRAB7511000_081 IS 'Delegados en empresas de 751-1000';



COMMENT ON COLUMN W83B81T00.T_TRABM1000_081 IS 'Delegados en empresas de ms de 1000';





CREATE UNIQUE INDEX PK_W83B81T00 ON W83B81T00

(C_TERRIT_081, ANO_RES_081, MES_RES_081, C_COMAR_081, C_MUNI_081, 

C_SINDI_081)

LOGGING

TABLESPACE W8302E00

PCTFREE    10

INITRANS   2

MAXTRANS   255

STORAGE    (

            INITIAL          160K

            NEXT             128K

            MINEXTENTS       1

            MAXEXTENTS       2147483645

            PCTINCREASE      0

            FREELISTS        1

            FREELIST GROUPS  1

            BUFFER_POOL      DEFAULT

           )

NOPARALLEL;





CREATE OR REPLACE SYNONYM W83B81S00 FOR W83B81T00;





ALTER TABLE W83B81T00 ADD (

  CONSTRAINT PK_W83B81T00 PRIMARY KEY (C_TERRIT_081, ANO_RES_081, MES_RES_081, C_COMAR_081, C_MUNI_081, C_SINDI_081)

    USING INDEX 

    TABLESPACE W8302E00

    PCTFREE    10

    INITRANS   2

    MAXTRANS   255

    STORAGE    (

                INITIAL          160K

                NEXT             128K

                MINEXTENTS       1

                MAXEXTENTS       2147483645

                PCTINCREASE      0

                FREELISTS        1

                FREELIST GROUPS  1

               ));



/* **************************************************************************************************** */			   

ALTER TABLE W83B12T00 ADD (

  CONSTRAINT FK_W83B12T00_01 FOREIGN KEY (C_FASE_012) 

    REFERENCES W83B52T00 (C_FASE_052));

/* **************************************************************************************************** */

ALTER TABLE W83B13T00 ADD (

  CONSTRAINT FK_W83B13T00_01 FOREIGN KEY (CEMPR_013) 

    REFERENCES W83B29T00 (CEMPR_029));

/* **************************************************************************************************** */

ALTER TABLE W83B15T00 ADD (

  CONSTRAINT FK_W83B15T00_02 FOREIGN KEY (C_AGRU_015) 

    REFERENCES W83B14T00 (C_AGRU_014));



ALTER TABLE W83B15T00 ADD (

  CONSTRAINT FK_W83B15T00_01 FOREIGN KEY (C_CONV_015) 

    REFERENCES W83B13T00 (C_CONV_013));

/* **************************************************************************************************** */	

ALTER TABLE W83B16T00 ADD (

  CONSTRAINT FK_W83B16T00_02 FOREIGN KEY (CBAJA_016) 

    REFERENCES W83B17T00 (CBAJA_017));



ALTER TABLE W83B16T00 ADD (

  CONSTRAINT FK_W83B16T00_01 FOREIGN KEY (C_CONV_016) 

    REFERENCES W83B13T00 (C_CONV_013));



ALTER TABLE W83B16T00 ADD (

  CONSTRAINT FK_W83B16T00_03 FOREIGN KEY (N_PREAVISO_016, ANO_PREAVISO_016, C_TERRIT_016) 

    REFERENCES W83B37T00 (N_PREAVISO_037,ANO_PREAVISO_037,C_TERRIT_037));	

/* **************************************************************************************************** */	

ALTER TABLE W83B18T00 ADD (

  CONSTRAINT FK_W83B18T00_01 FOREIGN KEY (C_SINDI_018) 

    REFERENCES W83B19T00 (C_SINDI_019));



ALTER TABLE W83B18T00 ADD (

  CONSTRAINT FK_W83B18T00_03 FOREIGN KEY (C_COLEG_018) 

    REFERENCES W83B23T00 (C_COLEG_023));



ALTER TABLE W83B18T00 ADD (

  CONSTRAINT FK_W83B18T00_02 FOREIGN KEY (N_ACTA_018, ANO_ACTA_018, C_TERRIT_018, VERSION_018) 

    REFERENCES W83B16T00 (N_ACTA_016,ANO_ACTA_016,C_TERRIT_016,VERSION_016));

/* **************************************************************************************************** */

ALTER TABLE W83B20T00 ADD (

  CONSTRAINT FK_W83B20T00_01 FOREIGN KEY (TP_DOC_020, C_TRAM_020, C_FASE_020) 

    REFERENCES W83B69T00 (IDTP_DOC_069,C_TRAM_069,C_FASE_069));

/* **************************************************************************************************** */	

ALTER TABLE W83B24T00 ADD (

  CONSTRAINT FK_W83B24T00_03 FOREIGN KEY (C_COLEG_024) 

    REFERENCES W83B23T00 (C_COLEG_023));



ALTER TABLE W83B24T00 ADD (

  CONSTRAINT FK_W83B24T00_02 FOREIGN KEY (C_SINDI_024) 

    REFERENCES W83B19T00 (C_SINDI_019));



ALTER TABLE W83B24T00 ADD (

  CONSTRAINT FK_W83B24T00_01 FOREIGN KEY (N_ACTA_024, ANO_ACTA_024, C_TERRIT_024, VERSION_024) 

    REFERENCES W83B16T00 (N_ACTA_016,ANO_ACTA_016,C_TERRIT_016,VERSION_016));	

/* **************************************************************************************************** */

ALTER TABLE W83B25T00 ADD (

  CONSTRAINT FK_W83B25T00_02 FOREIGN KEY (CBAJA_025) 

    REFERENCES W83B26T00 (CBAJA_026));



ALTER TABLE W83B25T00 ADD (

  CONSTRAINT FK_W83B25T00_03 FOREIGN KEY (C_COLEG_025) 

    REFERENCES W83B23T00 (C_COLEG_023));



ALTER TABLE W83B25T00 ADD (

  CONSTRAINT FK_W83B25T00_01 FOREIGN KEY (C_SINDI_025) 

    REFERENCES W83B19T00 (C_SINDI_019));	

/* **************************************************************************************************** */

ALTER TABLE W83B27T00 ADD (

  CONSTRAINT FK_W83B27T00_01 FOREIGN KEY (C_SINDI_027) 

    REFERENCES W83B19T00 (C_SINDI_019));



ALTER TABLE W83B27T00 ADD (

  CONSTRAINT FK_W83B27T00_02 FOREIGN KEY (N_PREAVISO_027, ANO_PREAVISO_027, C_TERRIT_027) 

    REFERENCES W83B37T00 (N_PREAVISO_037,ANO_PREAVISO_037,C_TERRIT_037));	

/* **************************************************************************************************** */

ALTER TABLE W83B31T00 ADD (

  CONSTRAINT FK_W83B31T00_01 FOREIGN KEY (CTIPVOZ_031) 

    REFERENCES W83B32T00 (CTIPVOZ_032));	

/* **************************************************************************************************** */	

ALTER TABLE W83B33T00 ADD (

  CONSTRAINT FK_W83B33T00_01 FOREIGN KEY (N_PREAVISO_033, ANO_PREAVISO_033, C_TERRIT_033) 

    REFERENCES W83B37T00 (N_PREAVISO_037,ANO_PREAVISO_037,C_TERRIT_037));



ALTER TABLE W83B33T00 ADD (

  CONSTRAINT FK_W83B33T00_03 FOREIGN KEY (N_ACTA_033, ANO_ACTA_033, C_TERRIT_033, VERSION_033) 

    REFERENCES W83B16T00 (N_ACTA_016,ANO_ACTA_016,C_TERRIT_016,VERSION_016));



ALTER TABLE W83B33T00 ADD (

  CONSTRAINT FK_W83B33T00_02 FOREIGN KEY (DNI_033, C_TERRIT_033) 

    REFERENCES W83B36T00 (DNI_036,C_TERRIT_036));



ALTER TABLE W83B33T00 ADD (

  FOREIGN KEY (C_IMPUG_033) 

    REFERENCES W83B30T00 (C_IMPUG_030));



/* **************************************************************************************************** */	

ALTER TABLE W83B34T00 ADD (

  CONSTRAINT FK_W83B34T00_01 FOREIGN KEY (N_LAUDO_034, ANO_LAUDO_034, C_TERRIT_034, ANO_IMPUG_034, N_IMPUG_034) 

    REFERENCES W83B68T00 (N_LAUDO_068, ANO_LAUDO_068, C_TERRIT_068, ANO_IMPUG_068, N_IMPUG_068));



ALTER TABLE W83B34T00 ADD (

  CONSTRAINT FK_W83B34T00_02 FOREIGN KEY (CVOZ_034, CTIPVOZ_034) 

    REFERENCES W83B31T00 (CVOZ_031, CTIPVOZ_031));

/* **************************************************************************************************** */	

ALTER TABLE W83B35T00 ADD (

  CONSTRAINT FK_W83B35T00_01 FOREIGN KEY (C_SINDI_035) 

    REFERENCES W83B19T00 (C_SINDI_019));



ALTER TABLE W83B35T00 ADD (

  CONSTRAINT FK_W83B35T00_02 FOREIGN KEY (N_IMPUG_035, ANO_IMPUG_035, C_TERRIT_035) 

    REFERENCES W83B33T00 (N_IMPUG_033,ANO_IMPUG_033,C_TERRIT_033));

/* **************************************************************************************************** */	

ALTER TABLE W83B37T00 ADD (

  CONSTRAINT FK_W83B37T00_01 FOREIGN KEY (C_CONV_037) 

    REFERENCES W83B13T00 (C_CONV_013));

/* **************************************************************************************************** */

ALTER TABLE W83B38T00 ADD (

  CONSTRAINT FK_W83B38T00_02 FOREIGN KEY (N_PREAVISO_038, ANO_PREAVISO_038, C_TERRIT_038, C_TRAM_038, C_FASE_038, F_ACTU_038) 

    REFERENCES W83B56T00 (N_PREAVISO_056,ANO_PREAVISO_056,C_TERRIT_056,C_TRAM_056,C_FASE_056,F_ACTU_056));

/* **************************************************************************************************** */

ALTER TABLE W83B38T00 ADD (

  CONSTRAINT FK_W83B38T00_01 FOREIGN KEY (TP_DOC_038, C_TRAM_038, C_FASE_038) 

    REFERENCES W83B69T00 (IDTP_DOC_069,C_TRAM_069,C_FASE_069));



	/* **************************************************************************************************** */

ALTER TABLE W83B40T00 ADD (

  CONSTRAINT FK_W83B40T00_01 FOREIGN KEY (PERFIL_040) 

    REFERENCES W83B39T00 (CPERF_039));



/* **************************************************************************************************** */

ALTER TABLE W83B41T00 ADD (

  CONSTRAINT FK_W83B41T00_01 FOREIGN KEY (N_IMPUG_041, ANO_IMPUG_041, C_TERRIT_041, C_TRAM_041, C_FASE_041, F_ACTU_041) 

    REFERENCES W83B71T00 (N_IMPUG_071,ANO_IMPUG_071,C_TERRIT_071,C_TRAM_071,C_FASE_071,F_ACTU_071));



ALTER TABLE W83B41T00 ADD (

  CONSTRAINT FK_W83B41T00_02 FOREIGN KEY (TP_DOC_041, C_TRAM_041, C_FASE_041) 

    REFERENCES W83B69T00 (IDTP_DOC_069,C_TRAM_069,C_FASE_069));

/* **************************************************************************************************** */

ALTER TABLE W83B44T00 ADD (

  CONSTRAINT FK_W83B44T00_01 FOREIGN KEY (C_COLEG_044) 

    REFERENCES W83B23T00 (C_COLEG_023));



ALTER TABLE W83B44T00 ADD (

  CONSTRAINT FK_W83B44T00_02 FOREIGN KEY (N_ACTA_044, ANO_ACTA_044, C_TERRIT_044, VERSION_044) 

    REFERENCES W83B16T00 (N_ACTA_016,ANO_ACTA_016,C_TERRIT_016,VERSION_016));

/* **************************************************************************************************** */

ALTER TABLE W83B53T00 ADD (

  CONSTRAINT FK_W83B53T00_01 FOREIGN KEY (N_PREAVISO_053, ANO_PREAVISO_053, C_TERRIT_053) 

    REFERENCES W83B37T00 (N_PREAVISO_037,ANO_PREAVISO_037,C_TERRIT_037));



ALTER TABLE W83B53T00 ADD (

  CONSTRAINT FK_W83B53T00_02 FOREIGN KEY (C_CONV_053) 

    REFERENCES W83B13T00 (C_CONV_013));

/* **************************************************************************************************** */

ALTER TABLE W83B54T00 ADD (

  CONSTRAINT FK_W83B54T00_02 FOREIGN KEY (C_SINDI_054) 

    REFERENCES W83B19T00 (C_SINDI_019));



ALTER TABLE W83B54T00 ADD (

  CONSTRAINT FK_W83B54T00_01 FOREIGN KEY (N_PREAVISO_054, ANO_PREAVISO_054, C_TERRIT_054) 

    REFERENCES W83B53T00 (N_PREAVISO_053,ANO_PREAVISO_053,C_TERRIT_053));

/* **************************************************************************************************** */

ALTER TABLE W83B55T00 ADD (

  CONSTRAINT FK_W83B55T00_01 FOREIGN KEY (N_PREAVISO_055, ANO_PREAVISO_055, C_TERRIT_055) 

    REFERENCES W83B37T00 (N_PREAVISO_037,ANO_PREAVISO_037,C_TERRIT_037));

/* **************************************************************************************************** */

ALTER TABLE W83B56T00 ADD (

  CONSTRAINT FK_W83B56T00_02 FOREIGN KEY (C_TRAM_056, C_FASE_056) 

    REFERENCES W83B12T00 (C_TRAM_012,C_FASE_012));



ALTER TABLE W83B56T00 ADD (

  CONSTRAINT FK_W83B56T00_01 FOREIGN KEY (N_PREAVISO_056, ANO_PREAVISO_056, C_TERRIT_056) 

    REFERENCES W83B37T00 (N_PREAVISO_037,ANO_PREAVISO_037,C_TERRIT_037));

/* **************************************************************************************************** */	

ALTER TABLE W83B58T00 ADD (

  CONSTRAINT FK_W83B58T00_02 FOREIGN KEY (C_TRAM_058, C_FASE_058) 

    REFERENCES W83B12T00 (C_TRAM_012,C_FASE_012));



ALTER TABLE W83B58T00 ADD (

  CONSTRAINT FK_W83B58T00_01 FOREIGN KEY (N_ACTA_058, ANO_ACTA_058, C_TERRIT_058, VERSION_058) 

    REFERENCES W83B16T00 (N_ACTA_016,ANO_ACTA_016,C_TERRIT_016,VERSION_016));

/* **************************************************************************************************** */	

ALTER TABLE W83B59T00 ADD (

  CONSTRAINT FK_W83B59T00_01 FOREIGN KEY (NUM_IMPUGNAC_059, ANO_IMPUGN_059, C_TERRIT_059) 

    REFERENCES W83B33T00 (N_IMPUG_033,ANO_IMPUG_033,C_TERRIT_033));

/* **************************************************************************************************** */

ALTER TABLE W83B60T00 ADD (

  CONSTRAINT FK_W83B60T00_02 FOREIGN KEY (C_SINDI_060) 

    REFERENCES W83B19T00 (C_SINDI_019));



ALTER TABLE W83B60T00 ADD (

  CONSTRAINT FK_W83B60T00_01 FOREIGN KEY (ANO_IMPUGN_060, NUM_IMPUGNAC_060, C_TERRIT_060) 

    REFERENCES W83B59T00 (ANO_IMPUGN_059,NUM_IMPUGNAC_059,C_TERRIT_059));

/* **************************************************************************************************** */	

ALTER TABLE W83B61T00 ADD (

  CONSTRAINT FK_W83B61T00_03 FOREIGN KEY (TP_INCIDENCIA_061) 

    REFERENCES W83B62T00 (TP_INCIDENCIA_062));



ALTER TABLE W83B61T00 ADD (

  CONSTRAINT FK_W83B61T00_01 FOREIGN KEY (TP_SOLICIT_061) 

    REFERENCES W83B63T00 (TP_SOLICIT_063));



ALTER TABLE W83B61T00 ADD (

  CONSTRAINT FK_W83B61T00_02 FOREIGN KEY (N_ACTA_061, ANO_ACTA_061, C_TERRIT_061, VERSION_ACTA_061) 

    REFERENCES W83B16T00 (N_ACTA_016,ANO_ACTA_016,C_TERRIT_016,VERSION_016));

/* **************************************************************************************************** */

ALTER TABLE W83B64T00 ADD (

  CONSTRAINT FK_W83B64T00_01 FOREIGN KEY (N_INCID_064, ANO_INCID_064, C_TERRIT_064, C_TRAM_064, C_FASE_064, F_ACTU_064) 

    REFERENCES W83B72T00 (N_INCID_072,ANO_INCID_072,C_TERRIT_072,C_TRAM_072,C_FASE_072,F_ACTU_072));



ALTER TABLE W83B64T00 ADD (

  CONSTRAINT FK_W83B64T00_02 FOREIGN KEY (TP_DOC_064, C_TRAM_064, C_FASE_064) 

    REFERENCES W83B69T00 (IDTP_DOC_069,C_TRAM_069,C_FASE_069));

/* **************************************************************************************************** */	

ALTER TABLE W83B66T00 ADD (

  CONSTRAINT FK_W83B66T00_02 FOREIGN KEY (N_INCID_066, ANO_INCID_066, C_TERRIT_066) 

    REFERENCES W83B61T00 (N_INCID_061,ANO_INCID_061,C_TERRIT_061));



ALTER TABLE W83B66T00 ADD (

  CONSTRAINT FK_W83B66T00_01 FOREIGN KEY (COD_CAMPO_066) 

    REFERENCES W83B65T00 (COD_CAMPO_065));

/* **************************************************************************************************** */

ALTER TABLE W83B67T00 ADD (

  CONSTRAINT FK_W83B67T00_01 FOREIGN KEY (N_INCID_067, ANO_INCID_067, C_TERRIT_067) 

    REFERENCES W83B61T00 (N_INCID_061,ANO_INCID_061,C_TERRIT_061));

/* **************************************************************************************************** */	

ALTER TABLE W83B68T00 ADD (

  CONSTRAINT FK_W83B68T00_01 FOREIGN KEY (N_IMPUG_068, ANO_IMPUG_068, C_TERRIT_068) 

    REFERENCES W83B33T00 (N_IMPUG_033,ANO_IMPUG_033,C_TERRIT_033));



ALTER TABLE W83B68T00 ADD (

  CONSTRAINT FK_W83B68T00_02 FOREIGN KEY (RDO_LAUDO_068) 

    REFERENCES W83B75T00 (ID_RDO_075));

/* **************************************************************************************************** */

ALTER TABLE W83B69T00 ADD (

  CONSTRAINT FK_W83B69T00_01 FOREIGN KEY (C_TRAM_069, C_FASE_069) 

    REFERENCES W83B12T00 (C_TRAM_012,C_FASE_012));

/* **************************************************************************************************** */

ALTER TABLE W83B70T00 ADD (

  CONSTRAINT FK_W83B70T00_01 FOREIGN KEY (C_TRAM_070, C_FASE_070) 

    REFERENCES W83B12T00 (C_TRAM_012,C_FASE_012));

/* **************************************************************************************************** */	

ALTER TABLE W83B71T00 ADD (

  CONSTRAINT FK_W83B71T00_02 FOREIGN KEY (C_TRAM_071, C_FASE_071) 

    REFERENCES W83B12T00 (C_TRAM_012,C_FASE_012));



ALTER TABLE W83B71T00 ADD (

  CONSTRAINT FK_W83B71T00_01 FOREIGN KEY (N_IMPUG_071, ANO_IMPUG_071, C_TERRIT_071) 

    REFERENCES W83B33T00 (N_IMPUG_033,ANO_IMPUG_033,C_TERRIT_033));

/* **************************************************************************************************** */

ALTER TABLE W83B72T00 ADD (

  CONSTRAINT FK_W83B72T00_01 FOREIGN KEY (C_TRAM_072, C_FASE_072) 

    REFERENCES W83B12T00 (C_TRAM_012,C_FASE_012));



ALTER TABLE W83B72T00 ADD (

  CONSTRAINT FK_W83B72T00_02 FOREIGN KEY (N_INCID_072, ANO_INCID_072, C_TERRIT_072) 

    REFERENCES W83B61T00 (N_INCID_061,ANO_INCID_061,C_TERRIT_061));

/* **************************************************************************************************** */

ALTER TABLE W83B73T00 ADD (

  CONSTRAINT FK_W83B73T00_01 FOREIGN KEY (N_IMPUG_073, ANO_IMPUG_073, C_TERRIT_073) 

    REFERENCES W83B33T00 (N_IMPUG_033,ANO_IMPUG_033,C_TERRIT_033));	

/* **************************************************************************************************** */	

ALTER TABLE W83B74T00 ADD (

  CONSTRAINT FK_W83B74T00_01 FOREIGN KEY (N_INCID_074, ANO_INCID_074, C_TERRIT_074) 

    REFERENCES W83B61T00 (N_INCID_061,ANO_INCID_061,C_TERRIT_061));

/* **************************************************************************************************** */

ALTER TABLE W83B76T00 ADD (

  CONSTRAINT FK_W83B76T00_01 FOREIGN KEY (N_IMPUG_076, ANO_IMPUG_076, C_TERRIT_076) 

    REFERENCES W83B33T00 (N_IMPUG_033,ANO_IMPUG_033,C_TERRIT_033));

	

/* ******************************************************************************* */		



 CREATE OR REPLACE SYNONYM J7300S00 FOR "J73B"."J73B00T00"@"J73B_DBL0.WORLD";

 CREATE OR REPLACE SYNONYM J7301S00 FOR "J73B"."J73B01V00"@"J73B_DBL0.WORLD";

 CREATE OR REPLACE SYNONYM J7301S01 FOR "J73B"."J73B01V00"@"J73B_DBL0.WORLD";

 CREATE OR REPLACE SYNONYM J7303S00 FOR "J73B"."J73B03T00"@"J73B_DBL0.WORLD";

 CREATE OR REPLACE SYNONYM J7304S00 FOR "J73B"."J73B04T00"@"J73B_DBL0.WORLD";

 CREATE OR REPLACE SYNONYM J7305S00 FOR "J73B"."J73B05T00"@"J73B_DBL0.WORLD";

 CREATE OR REPLACE SYNONYM J7306S00 FOR "J73B"."J73B06T00"@"J73B_DBL0.WORLD";

 



COMMIT;



